/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.tests.security.permissions;

import com.sun.ts.lib.tests.security.permissions.CTSPropertyPermissionCollection;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;

public final class CTSPropertyPermission
extends BasicPermission {
    private transient String methodName;
    private transient String actions;
    private transient int hashCodeValue = 0;
    private transient boolean isReadAction = false;
    private transient boolean isWriteAction = false;
    protected int mask = 0;
    private static int READ = 1;
    private static int WRITE = 2;

    public CTSPropertyPermission(String name) {
        this(name, "READ");
    }

    public CTSPropertyPermission(String name, String actions) {
        super(name);
        this.setActions(actions);
        this.mask = this.parseActions(actions);
    }

    private int parseActions(String action) {
        StringTokenizer st = new StringTokenizer(action, ", ");
        this.mask = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("READ")) {
                this.mask |= READ;
                continue;
            }
            if (token.equals("WRITE")) {
                this.mask |= WRITE;
                continue;
            }
            this.mask |= READ;
        }
        return this.mask;
    }

    public int getMask() {
        return this.mask;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof CTSPropertyPermission)) {
            return false;
        }
        CTSPropertyPermission that = (CTSPropertyPermission)o;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (this.methodName != null ? that.methodName == null || !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.actions != null ? that.actions == null || !this.actions.equals(that.actions) : that.actions != null) {
            return false;
        }
        return that.mask == this.mask;
    }

    public static String getActions(int mask) {
        if (mask == 0) {
            return "";
        }
        if (mask == READ) {
            return "READ";
        }
        if (mask == WRITE) {
            return "WRITE";
        }
        if (mask == (READ | WRITE)) {
            return "READ,WRITE";
        }
        System.out.println("in getActions():  bad value for mask = " + mask);
        return "ZZZ";
    }

    public void setActions(String val) {
        this.actions = val;
        this.actions = this.actions.toUpperCase();
        if (this.actions.contains("READ")) {
            this.isReadAction = true;
        }
        if (this.actions.contains("WRITE")) {
            this.isWriteAction = true;
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String val) {
        this.methodName = val;
    }

    @Override
    public int hashCode() {
        if (this.hashCodeValue == 0) {
            Object hash = this.getName();
            if (this.actions != null) {
                hash = (String)hash + " " + this.actions;
            }
            this.hashCodeValue = ((String)hash).hashCode();
        }
        return this.hashCodeValue;
    }

    @Override
    public boolean implies(Permission permission) {
        this.debug("enterred CTSPropertyPermission.implies()");
        CTSPropertyPermission that = (CTSPropertyPermission)permission;
        if (permission == null || !(permission instanceof CTSPropertyPermission)) {
            this.debug("in implies():  permission ! instance of CTSPropertyPermission");
            return false;
        }
        if (!this.getName().equals("*") && !this.getName().equals(that.getName())) {
            this.debug("in implies():  this.getName() != that.getName()");
            return false;
        }
        if ((this.mask & that.mask) != that.mask) {
            this.debug("in implies():  masks not equal");
            return false;
        }
        if (!(this.methodName == null || that.methodName != null && this.methodName.equals(that.methodName))) {
            this.debug("that.methodName = " + that.methodName);
            this.debug("this.methodName = " + this.methodName);
            return false;
        }
        String strName = that.getName();
        this.debug("in implies():  strName = " + strName);
        this.debug("in implies():  this.actions() = " + this.getActions());
        this.debug("in implies():  that.actions() = " + that.getActions());
        if (this.getIsReadAction() != that.getIsReadAction()) {
            this.debug("in implies(): this.getIsReadAction() != that.getIsReadAction()");
            return false;
        }
        if (this.getIsWriteAction() != that.getIsWriteAction()) {
            this.debug("in implies(): this.getIsWriteAction() != that.getIsWriteAction()");
            return false;
        }
        return true;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new CTSPropertyPermissionCollection();
    }

    public void setIsReadAction(boolean val) {
        this.isReadAction = val;
    }

    public boolean getIsReadAction() {
        return this.isReadAction;
    }

    public void setIsWriteAction(boolean val) {
        this.isWriteAction = val;
    }

    public boolean getIsWriteAction() {
        return this.isWriteAction;
    }

    private void debug(String str) {
        System.err.println(str);
    }
}

