/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.ejbliteshare;

import com.sun.javatest.Status;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.BASE64Encoder;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.ejbliteshare.ReasonableStatus;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.logging.Logger;

public class EJBLiteSecuredWebVehicleRunner
implements VehicleRunnable {
    private static final Logger logger = Logger.getLogger(EJBLiteSecuredWebVehicleRunner.class.getName());

    protected String getServletPath(String vehicle) {
        return "/" + vehicle + "_vehicle.jsp";
    }

    @Override
    public Status run(String[] argv, Properties p) {
        String testName = p.getProperty("testName");
        String vehicle = p.getProperty("vehicle");
        String contextRoot = p.getProperty("vehicle_archive_name");
        String queryString = "?testName=" + testName;
        String requestUrl = "/" + contextRoot + this.getServletPath(vehicle) + queryString;
        String username = p.getProperty("user");
        String password = p.getProperty("password");
        TSURL ctsURL = new TSURL();
        URL url = null;
        HttpURLConnection connection = null;
        int statusCode = 3;
        Object response = null;
        try {
            url = ctsURL.getURL("http", p.getProperty("webServerHost"), Integer.parseInt(p.getProperty("webServerPort")), requestUrl);
            String authData = username + ":" + password;
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            logger.info("Connecting " + url.toExternalForm());
            connection.connect();
            response = TestUtil.getResponse((URLConnection)connection).trim();
            statusCode = ((String)response).indexOf("[TEST PASSED] ") >= 0 ? 0 : 1;
        }
        catch (IOException e) {
            statusCode = 1;
            response = "Failed to connect to the test webapp." + TestUtil.printStackTraceToString((Throwable)e);
        }
        return new ReasonableStatus(statusCode, (String)response);
    }
}

