/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.schedule.tx;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb32.lite.timer.schedule.tx.ScheduleTxBeanBase;
import jakarta.annotation.Resource;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.util.logging.Level;

@Stateless
@TransactionManagement(value=TransactionManagementType.BEAN)
public class ScheduleBMTBean
extends ScheduleTxBeanBase {
    @Resource
    private UserTransaction ut;

    @Override
    protected void setRollbackOnly() {
        try {
            this.ut.setRollbackOnly();
        }
        catch (SystemException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected void beginTransaction() {
        try {
            this.ut.begin();
        }
        catch (NotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected void commitTransaction() {
        try {
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().logp(Level.FINE, "ScheduleBMTBean", "commitTransaction", "About to commit UserTransaction, current status " + TestUtil.getTransactionStatus((int)this.ut.getStatus()));
                this.ut.commit();
            } else if (this.ut.getStatus() == 1) {
                Helper.getLogger().logp(Level.FINE, "ScheduleBMTBean", "commitTransaction", "About to roll back UserTransaction, current status " + TestUtil.getTransactionStatus((int)this.ut.getStatus()));
                this.ut.rollback();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

