/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.SocketConnection;
import com.sun.javatest.util.DynamicArray;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class ActiveAgentPool {
    private static int entryWatcherCount;
    private static boolean debug;
    private static final int MAX_ERRORS = 10;
    private Thread worker;
    private int counter;
    private Entries entries = new Entries();
    private ServerSocket serverSocket;
    private int timeout = 180000;
    private int port = 1907;

    public synchronized void listen(int port, int timeout) throws IOException {
        this.setListening(false);
        this.setPort(port);
        this.setTimeout(timeout);
        this.setListening(true);
    }

    public synchronized int getPort() {
        return this.port == 0 && this.serverSocket != null ? this.serverSocket.getLocalPort() : this.port;
    }

    public synchronized void setPort(int port) {
        this.port = port;
    }

    public synchronized int getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public synchronized boolean isListening() {
        return this.serverSocket != null;
    }

    public synchronized void setListening(boolean listen) throws IOException {
        if (debug) {
            new Exception("ActiveAgentPool.setListening " + listen + ",port=" + this.port).printStackTrace(System.err);
        }
        if (listen) {
            if (this.serverSocket != null) {
                if (this.port == 0 || this.serverSocket.getLocalPort() == this.port) {
                    return;
                }
                this.closeNoExceptions(this.serverSocket);
            }
            this.serverSocket = SocketConnection.createServerSocket(this.port);
            Runnable r = this::acceptRequests;
            Thread worker = new Thread(r, "ActiveAgentPool" + this.counter++);
            worker.start();
        } else {
            Entry e;
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            this.serverSocket = null;
            while ((e = this.entries.next()) != null) {
                this.closeNoExceptions(e);
            }
        }
    }

    Entry nextAgent() throws NoAgentException, InterruptedException {
        if (!this.isListening()) {
            throw new NoAgentException("AgentPool not listening");
        }
        Entry e = this.entries.next(this.timeout);
        if (e != null) {
            return e;
        }
        throw new NoAgentException("Timeout waiting for agent to become available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void acceptRequests() {
        ServerSocket ss;
        ActiveAgentPool activeAgentPool = this;
        synchronized (activeAgentPool) {
            ss = this.serverSocket;
        }
        int errors = 0;
        while (errors < 10) {
            ActiveAgentPool activeAgentPool2;
            try {
                Socket s = ss.accept();
                activeAgentPool2 = this;
                synchronized (activeAgentPool2) {
                    if (ss != this.serverSocket) {
                        this.closeNoExceptions(s);
                        return;
                    }
                    this.entries.add(new Entry(s));
                    if (errors <= 0) continue;
                }
                --errors;
            }
            catch (IOException e) {
                activeAgentPool2 = this;
                synchronized (activeAgentPool2) {
                    if (ss != this.serverSocket) {
                        // MONITOREXIT @DISABLED, blocks:[1, 18, 19, 12, 15] lbl25 : MonitorExitStatement: MONITOREXIT : var4_6
                        this.closeNoExceptions(ss);
                        return;
                    }
                }
                System.err.println("error opening socket for remote socket pool");
                System.err.println(e.getMessage());
                ++errors;
            }
        }
        System.err.println("too many errors opening socket for remote socket pool");
        System.err.println("server thread exiting");
        ActiveAgentPool activeAgentPool3 = this;
        synchronized (activeAgentPool3) {
            if (this.serverSocket != ss) return;
            this.serverSocket = null;
            return;
        }
        finally {
            this.closeNoExceptions(ss);
        }
    }

    Enumeration<Connection> elements() {
        return this.entries.elements();
    }

    public void addObserver(Observer o) {
        this.entries.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.entries.deleteObserver(o);
    }

    private void closeNoExceptions(Entry e) {
        try {
            e.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeNoExceptions(Socket s) {
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeNoExceptions(ServerSocket ss) {
        try {
            ss.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        debug = Boolean.getBoolean("debug.ActiveAgentPool");
    }

    class Entries {
        private Vector<Entry> v = new Vector();
        private Observer[] observers = new Observer[0];

        Entries() {
        }

        synchronized boolean contains(Entry e) {
            return this.v.contains(e);
        }

        synchronized Enumeration<Connection> elements() {
            return ((Vector)this.v.clone()).elements();
        }

        synchronized void add(Entry e) {
            this.v.add(e);
            this.notifyAddedToPool(e);
            this.notifyAll();
            Runnable r = e::readAhead;
            Thread t = new Thread(r, "ActiveAgentPool.EntryWatcher" + entryWatcherCount++);
            t.start();
        }

        synchronized boolean remove(Entry e) {
            if (this.v.contains(e)) {
                this.v.remove(e);
                this.notifyRemovedFromPool(e);
                return true;
            }
            return false;
        }

        synchronized Entry next() {
            Entry e = null;
            if (!this.v.isEmpty()) {
                e = this.v.get(0);
                this.v.remove(0);
                this.notifyRemovedFromPool(e);
            }
            return e;
        }

        synchronized Entry next(int timeout) throws InterruptedException {
            long end = System.currentTimeMillis() + (long)timeout;
            long t = timeout;
            while (t > 0L) {
                Entry e;
                if (this.v.isEmpty()) {
                    this.wait(t);
                }
                if ((e = this.next()) != null) {
                    return e;
                }
                t = end - System.currentTimeMillis();
            }
            return null;
        }

        synchronized void addObserver(Observer o) {
            this.observers = DynamicArray.append(this.observers, o);
        }

        synchronized void deleteObserver(Observer o) {
            this.observers = DynamicArray.remove(this.observers, o);
        }

        private synchronized void notifyAddedToPool(Entry e) {
            for (Observer observer : this.observers) {
                observer.addedToPool(e);
            }
        }

        private synchronized void notifyRemovedFromPool(Entry e) {
            for (Observer observer : this.observers) {
                observer.removedFromPool(e);
            }
        }
    }

    class Entry
    implements Connection {
        private final Socket socket;
        private InputStream socketInput;
        private OutputStream socketOutput;
        private String name;
        private boolean reading;
        private Object data;
        private boolean closed;

        Entry(Socket socket) throws IOException {
            this.socket = socket;
            this.socketInput = socket.getInputStream();
            this.socketOutput = socket.getOutputStream();
        }

        @Override
        public String getName() {
            if (this.name == null) {
                StringBuilder sb = new StringBuilder(32);
                sb.append(this.socket.getInetAddress().getHostName());
                sb.append(",port=");
                sb.append(this.socket.getPort());
                sb.append(",localport=");
                sb.append(this.socket.getLocalPort());
                this.name = sb.toString();
            }
            return this.name;
        }

        @Override
        public synchronized InputStream getInputStream() {
            if (!this.reading && this.data == null) {
                return this.socketInput;
            }
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    byte[] b = new byte[1];
                    int n = this.read(b);
                    if (n == -1) {
                        return -1;
                    }
                    n = 0xFF & b[0];
                    return n;
                }

                @Override
                public int read(byte[] buffer, int offset, int count) throws IOException {
                    if (count == 0) {
                        return 0;
                    }
                    try {
                        Entry.this.waitWhileReading();
                        if (Entry.this.data == null) {
                            return new InterruptableReader().read(buffer, offset, count);
                        }
                    }
                    catch (InterruptedException ie) {
                        InterruptedIOException iio = new InterruptedIOException("Test execution timeout");
                        iio.fillInStackTrace();
                        throw iio;
                    }
                    try {
                        if (Entry.this.data instanceof Integer) {
                            int i = (Integer)Entry.this.data;
                            if (i == -1) {
                                int n = -1;
                                return n;
                            }
                            buffer[offset] = (byte)i;
                            int n = 1;
                            return n;
                        }
                        IOException e = (IOException)Entry.this.data;
                        e.fillInStackTrace();
                        throw e;
                    }
                    finally {
                        Entry.this.data = null;
                    }
                }

                @Override
                public void close() throws IOException {
                    Entry.this.socketInput.close();
                }
            };
        }

        @Override
        public OutputStream getOutputStream() {
            return this.socketOutput;
        }

        @Override
        public synchronized void close() throws IOException {
            this.socketInput.close();
            this.socketOutput.close();
            this.closed = true;
            this.notifyAll();
        }

        @Override
        public synchronized boolean isClosed() {
            return this.closed;
        }

        @Override
        public synchronized void waitUntilClosed(int timeout) throws InterruptedException {
            long now = System.currentTimeMillis();
            long end = now + (long)timeout;
            while (now < end && !this.closed) {
                this.wait(end - now);
                now = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readAhead() {
            Entry entry = this;
            synchronized (entry) {
                if (!ActiveAgentPool.this.entries.contains(this)) {
                    return;
                }
                this.reading = true;
            }
            try {
                this.data = this.socketInput.read();
            }
            catch (IOException e) {
                this.data = e;
            }
            finally {
                Entry entry2 = this;
                synchronized (entry2) {
                    boolean ok = ActiveAgentPool.this.entries.remove(this);
                    if (ok) {
                        ActiveAgentPool.this.closeNoExceptions(this);
                    }
                    this.reading = false;
                    this.notifyAll();
                }
            }
        }

        private synchronized void waitWhileReading() throws InterruptedException {
            while (this.reading) {
                this.wait();
            }
        }

        private class InterruptableReader {
            private IOException ioe;
            private int n;

            private InterruptableReader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] buffer, int offset, int count) throws IOException, InterruptedException {
                Entry entry = Entry.this;
                synchronized (entry) {
                    this.ioe = null;
                    this.n = -1;
                    this.readInThread(buffer, offset, count);
                    Entry.this.waitWhileReading();
                    if (this.ioe != null) {
                        throw this.ioe;
                    }
                    return this.n;
                }
            }

            private void readInThread(byte[] buffer, int offset, int count) {
                final byte[] b = buffer;
                final int o = offset;
                final int c = count;
                Thread reader = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            InterruptableReader.this.n = Entry.this.socketInput.read(b, o, c);
                        }
                        catch (IOException io) {
                            InterruptableReader.this.ioe = io;
                        }
                        finally {
                            Entry entry = Entry.this;
                            synchronized (entry) {
                                Entry.this.reading = false;
                                Entry.this.notifyAll();
                            }
                        }
                    }
                };
                Entry.this.reading = true;
                reader.start();
            }
        }
    }

    public static class NoAgentException
    extends Exception {
        public NoAgentException(String msg) {
            super(msg);
        }
    }

    public static interface Observer {
        public void addedToPool(Connection var1);

        public void removedFromPool(Connection var1);
    }
}

