/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerreader.interceptorcontext;

import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.ContextOperation;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.InputStreamReaderProvider;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.InterceptorBodyOne;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.InterceptorBodyTwo;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.InterceptorCallbackMethods;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.TemplateInterceptorBody;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.interceptorcontext.ReaderInterceptorOne;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.interceptorcontext.ReaderInterceptorTwo;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.TextCaser;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerreader.ReaderClient;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerreader.interceptorcontext.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerreader.interceptorcontext.TSAppConfig;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer.interceptorcontext.WriterInterceptorOne;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends ReaderClient<ContextOperation> {
    private static final long serialVersionUID = 6573164759617152350L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_ext_interceptor_containerreader_interceptorcontext_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/ext/interceptor/containerreader/interceptorcontext/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_ext_interceptor_containerreader_interceptorcontext_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, JaxrsUtil.class, JAXRSCommonClient.class, ContextOperation.class, InputStreamReaderProvider.class, InterceptorBodyOne.class, InterceptorBodyTwo.class, InterceptorCallbackMethods.class, TemplateInterceptorBody.class, ReaderInterceptorOne.class, ReaderInterceptorTwo.class, Resource.class});
        archive.addPackages(false, new String[]{"ee.jakarta.tck.ws.rs.common.client", "ee.jakarta.tck.ws.rs.common.webclient", "ee.jakarta.tck.ws.rs.common.webclient.handler", "ee.jakarta.tck.ws.rs.common.webclient.http", "ee.jakarta.tck.ws.rs.common.webclient.validation", "ee.jakarta.tck.ws.rs.api.rs.ext.interceptor", "ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader"});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void getAnnotationsTest() throws JAXRSCommonClient.Fault {
        Method m;
        try {
            m = Resource.class.getMethod("post", String.class);
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        Annotation[] annotations = m.getParameterAnnotations()[0];
        Entity entity = Entity.entity((Object)"Entity", (MediaType)MediaType.WILDCARD_TYPE, (Annotation[])annotations);
        this.setOperationAndEntity(ContextOperation.GETANNOTATIONS);
        this.setRequestContentEntity(entity);
        this.setTextCaser(TextCaser.LOWER);
        for (Annotation a : annotations) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, a.annotationType().getName());
        }
        this.invoke();
    }

    @Test
    public void getGenericTypeTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.GETGENERICTYPE);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.class.getName());
        this.invoke();
    }

    @Test
    public void getMediaTypeTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"Entity", (MediaType)MediaType.APPLICATION_JSON_TYPE);
        this.setOperationAndEntity(ContextOperation.GETMEDIATYPE);
        this.setRequestContentEntity(entity);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/json");
        this.invoke();
    }

    @Test
    public void getPropertyIsNullTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.GETPROPERTY);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "None");
        this.invoke();
    }

    @Test
    public void getPropertyNamesTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.GETPROPERTYNAMES);
        for (int i = 0; i != 5; ++i) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "Property" + i);
        }
        this.invoke();
    }

    @Test
    public void getPropertyNamesIsReadOnlyTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.GETPROPERTYNAMESISREADONLY);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "None");
        this.invoke();
    }

    @Test
    public void getTypeTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.GETTYPE);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.class.getName());
        this.invoke();
    }

    @Test
    public void removePropertyTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.REMOVEPROPERTY);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "None");
        this.invoke();
    }

    @Test
    public void setAnnotationsTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = WriterInterceptorOne.class.getAnnotations();
        this.setOperationAndEntity(ContextOperation.SETANNOTATIONS);
        this.setTextCaser(TextCaser.LOWER);
        for (Annotation a : annotations) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, a.annotationType().getName());
        }
        this.invoke();
    }

    @Test
    public void setAnnotationsNullThrowsNPETest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.SETANNOTATIONSNULL);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NullPointerException has been thrown as expected");
        this.invoke();
    }

    @Test
    public void setGenericTypeTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.SETGENERICTYPE);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "[B");
        this.invoke();
    }

    @Test
    public void setMediaTypeTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.SETMEDIATYPE);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/x-www-form-urlencoded");
        this.invoke();
    }

    @Test
    public void setPropertyTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.SETPROPERTY);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Other Entity");
        this.invoke();
    }

    @Test
    public void setPropertyNullTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.SETPROPERTYNULL);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "None");
        this.invoke();
    }

    @Test
    public void setTypeTest() throws JAXRSCommonClient.Fault {
        ByteArrayInputStream bais = new ByteArrayInputStream("Entity".getBytes());
        InputStreamReader reader = new InputStreamReader(bais);
        this.setOperationAndEntity(ContextOperation.SETTYPE);
        this.setRequestContentEntity(reader);
        this.addProvider(InputStreamReaderProvider.class);
        this.invoke("inputstreamreader");
        InputStreamReader isr = this.getResponseBody(InputStreamReader.class);
        try {
            String entity = JaxrsUtil.readFromReader(isr);
            Assertions.assertTrue((boolean)entity.contains(InputStreamReader.class.getName()), (String)("Expected" + InputStreamReader.class.getName() + "not found"));
            JAXRSClientIT.logMsg("#setType set correct type", entity);
        }
        catch (IOException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }
}

