<%--

    Copyright (c) 2005, 2020 Oracle and/or its affiliates. All rights reserved.

    This program and the accompanying materials are made available under the
    terms of the Eclipse Public License v. 2.0, which is available at
    http://www.eclipse.org/legal/epl-2.0.

    This Source Code may also be made available under the following Secondary
    Licenses when the conditions for such availability set forth in the
    Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
    version 2 with the GNU Classpath Exception, which is available at
    https://www.gnu.org/software/classpath/license.html.

    SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0

--%>

<%@ page import="com.sun.ts.tests.jsp.common.util.JspTestUtil,
             com.sun.ts.tests.jsp.api.jakarta_servlet.jsp.jspapplicationcontext.FooELResolver,
             jakarta.el.ELContext,
             jakarta.el.ELResolver"%>
<%@ page contentType="text/plain" %>

<% 
    if (pageContext != null) {
        ELContext elContext = pageContext.getELContext();

        if (elContext != null) {
            JspApplicationContext jaContext = 
                    JspFactory.getDefaultFactory().getJspApplicationContext(
                    pageContext.getServletContext());
            if (jaContext != null) {
                
                try {
                    jaContext.addELResolver(new FooELResolver()); 
                    out.println("addELResolver call succeeded. Test FAILED.");
                } catch (IllegalStateException ise) {
                    out.println("Test PASSED.");
                } catch (Throwable t) {
                    JspTestUtil.handleThrowable(t, out, "IllegalStateExceptionTest");
                }
            }
            else
                out.println("Test FAILED. Unable to obtain JspApplicationContext");
        }
        else
            out.println("Test FAILED. Unable to obtain ELContext");
    } 
    else 
        out.println("Test FAILED.  Unable to obtain PageContext.");
%>
