/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.sigfile.F40Writer;
import com.sun.tdk.signaturetest.sigfile.F41Format;

public class F41Writer
extends F40Writer {
    public F41Writer() {
        this.format = new F41Format();
    }

    @Override
    protected void writeHiders(ClassDescription classDescription, StringBuffer buf) {
        super.writeHiders(classDescription, buf);
        this.writeInternalMembers(buf, "x-fds", classDescription.getXFields());
        this.writeInternalMembers(buf, "x-cls", classDescription.getXClasses());
    }

    @Override
    protected void write(StringBuffer buf, ClassDescription m) {
        MemberType memberType = m.getMemberType();
        buf.append(memberType);
        String modifiers = Modifier.toString(memberType, m.getModifiers(), true);
        if (modifiers.length() != 0) {
            buf.append(' ');
            buf.append(modifiers);
        }
        buf.append(' ');
        buf.append(m.getQualifiedName());
        String typeParameters = m.getTypeParameters();
        if (typeParameters != null) {
            buf.append(typeParameters);
        }
        if (m.getOuterClass() != null && !m.getOuterClass().equals("")) {
            buf.append("\n outer ");
            buf.append(m.getOuterClass());
        }
        AnnotationItem[] annoList = m.getAnnoList();
        for (int i = 0; i < annoList.length; ++i) {
            buf.append("\n ");
            buf.append(annoList[i]);
        }
    }
}

