/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt18;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.Utils;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class callStmtClient18
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt18";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private rsSchema rsSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private CallableStatement cstmt = null;
    private Properties props = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        callStmtClient18 theTests = new callStmtClient18();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbmd = this.conn.getMetaData();
                this.stmt = this.conn.createStatement();
                this.rsSch = new rsSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject201() throws Exception {
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_In_Min(?)}");
            this.msg.setMsg("extract the Minimum Value to be Updated");
            smaxStringVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            Double maxDoubleVal = new Double(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxDoubleVal, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Double_Query_Min", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            Double rDoubleVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(maxDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject202() throws Exception {
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value to be Updated");
            sminStringVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            Double minDoubleVal = new Double(sminStringVal);
            this.cstmt.setObject(1, (Object)minDoubleVal, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Double_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Double rDoubleVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(minDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject203() throws Exception {
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value to be Updated");
            smaxStringVal = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            BigDecimal maxDecimalVal = new BigDecimal(smaxStringVal);
            Double maxDoubleVal = new Double(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxDoubleVal, 3, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            BigDecimal rDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxDecimalVal, "" + rDecimalVal);
            if (rDecimalVal.compareTo(maxDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject204() throws Exception {
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value to be Updated");
            sminStringVal = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            BigDecimal minDecimalVal = new BigDecimal(sminStringVal);
            Double minDoubleVal = new Double(sminStringVal);
            this.cstmt.setObject(1, (Object)minDoubleVal, 3, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            BigDecimal rDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minDecimalVal, "" + rDecimalVal);
            if (rDecimalVal.compareTo(minDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject205() throws Exception {
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value to be Updated");
            smaxStringVal = this.rsSch.extractVal("Numeric_Tab", 2, this.sqlp, this.conn);
            BigDecimal maxDecimalVal = new BigDecimal(smaxStringVal);
            Double maxDoubleVal = new Double(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxDoubleVal, 2, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            BigDecimal rDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxDecimalVal, "" + rDecimalVal);
            if (rDecimalVal.compareTo(maxDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject206() throws Exception {
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value to be Updated");
            sminStringVal = this.rsSch.extractVal("Numeric_Tab", 2, this.sqlp, this.conn);
            BigDecimal minDecimalVal = new BigDecimal(sminStringVal);
            Double minDoubleVal = new Double(sminStringVal);
            this.cstmt.setObject(1, (Object)minDoubleVal, 2, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            BigDecimal rDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minDecimalVal, "" + rDecimalVal);
            if (rDecimalVal.compareTo(minDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject209() throws Exception {
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_In_Name(?)}");
            this.msg.setMsg("extract the Minimum Value to be Updated");
            smaxStringVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            Double maxDoubleVal = Double.valueOf(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxDoubleVal, 1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Char_Query_Name", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            this.msg.addOutputMsg(maxDoubleVal.toString(), Double.valueOf(rStringVal).toString());
            if (Utils.isMatchingFloatingPointVal(maxDoubleVal, Double.valueOf(rStringVal))) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject210() throws Exception {
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value to be Updated");
            sminStringVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            Double minDoubleVal = Double.valueOf(sminStringVal);
            this.cstmt.setObject(1, (Object)minDoubleVal, 1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            this.msg.addOutputMsg(minDoubleVal.toString(), Double.valueOf(rStringVal).toString());
            if (Utils.isMatchingFloatingPointVal(minDoubleVal, Double.valueOf(rStringVal))) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject211() throws Exception {
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_In_Name(?)}");
            this.msg.setMsg("extract the Minimum Value to be Updated");
            smaxStringVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            Double maxDoubleVal = Double.valueOf(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxDoubleVal, 12);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Varchar_Query_Name", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            this.msg.addOutputMsg(maxDoubleVal.toString(), Double.valueOf(rStringVal).toString());
            if (Utils.isMatchingFloatingPointVal(maxDoubleVal, Double.valueOf(rStringVal))) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject212() throws Exception {
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value to be Updated");
            sminStringVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            Double minDoubleVal = Double.valueOf(sminStringVal);
            this.cstmt.setObject(1, (Object)minDoubleVal, 12);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            this.msg.addOutputMsg(minDoubleVal.toString(), Double.valueOf(rStringVal).toString());
            if (Utils.isMatchingFloatingPointVal(minDoubleVal, Double.valueOf(rStringVal))) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject213() throws Exception {
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Longvarchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_In_Name(?)}");
            this.msg.setMsg("extract the Minimum Value to be Updated");
            smaxStringVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            Double maxDoubleVal = Double.valueOf(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxDoubleVal, -1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Name", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            this.msg.addOutputMsg(maxDoubleVal.toString(), Double.valueOf(rStringVal).toString());
            if (Utils.isMatchingFloatingPointVal(maxDoubleVal, Double.valueOf(rStringVal))) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject214() throws Exception {
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value to be Updated");
            sminStringVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            Double minDoubleVal = Double.valueOf(sminStringVal);
            this.cstmt.setObject(1, (Object)minDoubleVal, -1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            this.msg.addOutputMsg(minDoubleVal.toString(), Double.valueOf(rStringVal).toString());
            if (Utils.isMatchingFloatingPointVal(minDoubleVal, Double.valueOf(rStringVal))) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject215() throws Exception {
        ResultSet rs = null;
        byte[] oRetVal = null;
        Object bytearrVal = null;
        String binarySize = null;
        try {
            binarySize = this.sqlp.getProperty("binarySize");
            this.msg.setMsg("Binary Table Size : " + binarySize);
            this.rsSch.createTab("Binary_Tab", this.sqlp, this.conn);
            int bytearrsize = Integer.parseInt(binarySize);
            this.msg.setMsg("Binary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Binary_Proc_In(?)}");
            this.cstmt.setObject(1, (Object)bytearr, -2);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Binary_Val_Query = this.sqlp.getProperty("Binary_Query_Val", "");
            this.msg.setMsg(Binary_Val_Query);
            rs = this.stmt.executeQuery(Binary_Val_Query);
            rs.next();
            oRetVal = (byte[])rs.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.setMsg("setObject Method sets the designated parameter with the object");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject216() throws Exception {
        ResultSet rs = null;
        byte[] oRetVal = null;
        Object bytearrVal = null;
        String varbinarySize = null;
        try {
            varbinarySize = this.sqlp.getProperty("varbinarySize");
            this.msg.setMsg("Varbinary Table Size : " + varbinarySize);
            this.rsSch.createTab("Varbinary_Tab", this.sqlp, this.conn);
            int bytearrsize = Integer.parseInt(varbinarySize);
            this.msg.setMsg("Varbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varbinary_Proc_In(?)}");
            this.cstmt.setObject(1, (Object)bytearr, -3);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Varbinary_Val_Query = this.sqlp.getProperty("Varbinary_Query_Val", "");
            this.msg.setMsg(Varbinary_Val_Query);
            rs = this.stmt.executeQuery(Varbinary_Val_Query);
            rs.next();
            oRetVal = (byte[])rs.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.setMsg("setObject Method sets the designated parameter with the object");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject217() throws Exception {
        ResultSet rs = null;
        byte[] oRetVal = null;
        Object bytearrVal = null;
        String longvarbinarySize = null;
        try {
            longvarbinarySize = this.sqlp.getProperty("longvarbinarySize");
            this.msg.setMsg("Longvarbinary Table Size : " + longvarbinarySize);
            this.rsSch.createTab("Longvarbinary_Tab", this.sqlp, this.conn);
            int bytearrsize = Integer.parseInt(longvarbinarySize);
            this.msg.setMsg("Varbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Longvarbinary_In(?)}");
            this.cstmt.setObject(1, (Object)bytearr, -4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Longvarbinary_Val_Query = this.sqlp.getProperty("Longvarbinary_Query_Val", "");
            this.msg.setMsg(Longvarbinary_Val_Query);
            rs = this.stmt.executeQuery(Longvarbinary_Val_Query);
            rs.next();
            oRetVal = (byte[])rs.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.setMsg("setObject Method sets the designated parameter with the object");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject218() throws Exception {
        ResultSet rs = null;
        Date oRetVal = null;
        Date mfgDateVal = null;
        String sMfgDateVal = null;
        String retStringVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            sMfgDateVal = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            sMfgDateVal = sMfgDateVal.substring(sMfgDateVal.indexOf(39) + 1, sMfgDateVal.lastIndexOf(39));
            mfgDateVal = Date.valueOf(sMfgDateVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_In_Null(?)}");
            this.cstmt.setObject(1, (Object)mfgDateVal, 1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            retStringVal = (String)rs.getObject(1);
            retStringVal = retStringVal.trim();
            oRetVal = Date.valueOf(retStringVal);
            this.msg.addOutputMsg("" + mfgDateVal, "" + oRetVal);
            if (oRetVal.equals(mfgDateVal)) {
                this.msg.setMsg("setObject method sets the designated parameter with the object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject219() throws Exception {
        ResultSet rs = null;
        Date oRetVal = null;
        Date mfgDateVal = null;
        String sMfgDateVal = null;
        String retStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            sMfgDateVal = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            sMfgDateVal = sMfgDateVal.substring(sMfgDateVal.indexOf(39) + 1, sMfgDateVal.lastIndexOf(39));
            mfgDateVal = Date.valueOf(sMfgDateVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_In_Null(?)}");
            this.cstmt.setObject(1, (Object)mfgDateVal, 12);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            retStringVal = (String)rs.getObject(1);
            oRetVal = Date.valueOf(retStringVal);
            this.msg.addOutputMsg("" + mfgDateVal, "" + oRetVal);
            if (oRetVal.equals(mfgDateVal)) {
                this.msg.setMsg("setObject method sets the designated parameter with the object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject220() throws Exception {
        ResultSet rs = null;
        Date oRetVal = null;
        Date mfgDateVal = null;
        String sMfgDateVal = null;
        String retStringVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            sMfgDateVal = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            sMfgDateVal = sMfgDateVal.substring(sMfgDateVal.indexOf(39) + 1, sMfgDateVal.lastIndexOf(39));
            sMfgDateVal = sMfgDateVal.trim();
            mfgDateVal = Date.valueOf(sMfgDateVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_In_Null(?)}");
            this.cstmt.setObject(1, (Object)mfgDateVal, -1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            retStringVal = (String)rs.getObject(1);
            retStringVal = retStringVal.trim();
            oRetVal = Date.valueOf(retStringVal);
            this.msg.addOutputMsg("" + mfgDateVal, "" + oRetVal);
            if (oRetVal.equals(mfgDateVal)) {
                this.msg.setMsg("setObject method sets the designated parameter with the object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "call to setObject is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

