/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.nativequery;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.nativequery.Item;
import ee.jakarta.tck.persistence.core.annotations.nativequery.Order1;
import ee.jakarta.tck.persistence.core.annotations.nativequery.Order2;
import ee.jakarta.tck.persistence.core.annotations.nativequery.PurchaseOrder;
import jakarta.persistence.TransactionRequiredException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void nativeQueryTest2() throws Exception {
        boolean pass = false;
        int passCounter = 0;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create Items");
            Item i1 = new Item(7, "Loafers");
            Item i2 = new Item(8, "High Heels");
            Item i3 = new Item(9, "Socks");
            this.logTrace("Create Orders");
            Order1 o7 = new Order1(7, 25.0);
            o7.setItem(i1);
            this.getEntityManager().persist((Object)o7);
            Order1 o8 = new Order1(8, 125.0);
            o8.setItem(i2);
            this.getEntityManager().persist((Object)o8);
            Order1 o9 = new Order1(9, 150.0);
            o9.setItem(i3);
            this.getEntityManager().persist((Object)o9);
            this.logTrace("Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.ID AS \"OID\", o.TOTALPRICE AS \"OPRICE\", o.FK1_FOR_ITEM AS \"OITEM\", i.ITEMNAME AS \"INAME\" from ORDER1 o, ITEM i WHERE (o.TOTALPRICE < 100) AND (o.FK1_FOR_ITEM = i.ID)", "Order2ItemResults").getResultList();
            if (q.size() != 1) {
                this.logErr(" Did not get expected results.  Expected: 1, got: " + q.size());
            } else {
                this.logTrace("Expected size received, verify contents . . . ");
                for (Object obj : q) {
                    Object[] objectArray;
                    if (!(obj instanceof Object[])) continue;
                    for (Object o : objectArray = (Object[])obj) {
                        if (o instanceof Order1) {
                            Order1 orderReturned = (Order1)o;
                            if (!orderReturned.equals(o7)) {
                                this.logErr("Expected:" + o7 + ", actual:" + orderReturned);
                            } else {
                                this.logTrace("Received expected order");
                                ++passCounter;
                            }
                            if (orderReturned.getItem() != i1) {
                                this.logErr("Expected:" + i1 + ", actual:" + orderReturned.getItem());
                                continue;
                            }
                            this.logTrace("Received expected item");
                            ++passCounter;
                            continue;
                        }
                        if (o instanceof String) {
                            String itemName = (String)o;
                            if (!itemName.equals(i1.getItemName())) {
                                this.logErr("Expected:" + i1.getItemName() + ", actual:" + itemName);
                                continue;
                            }
                            this.logTrace("Received expected itemName");
                            ++passCounter;
                            continue;
                        }
                        this.logErr("Received unexpected object:" + o);
                    }
                }
            }
            if (passCounter == 3) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("nativeQueryTest2 failed");
        }
    }

    public void nativeQueryTest3() throws Exception {
        boolean pass = false;
        int passCounter = 0;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            this.logTrace("Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            this.logTrace("Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.ID AS \"THISID\", o.TOTALPRICE AS \"THISPRICE\", o.FK1_FOR_ITEM AS \"THISITEM\", i.ID, i.ITEMNAME from ORDER1 o, ITEM i WHERE (o.TOTALPRICE > 140) AND (o.FK1_FOR_ITEM = i.ID)", "Order3ItemResults").getResultList();
            if (q.size() != 1) {
                this.logErr(" Did not get expected results.  Expected: 1, got: " + q.size());
            } else {
                this.logTrace("Expected size received, verify contents . . . ");
                for (Object obj : q) {
                    Object[] objectArray;
                    if (!(obj instanceof Object[])) continue;
                    for (Object o : objectArray = (Object[])obj) {
                        if (o instanceof Order1) {
                            Order1 orderReturned = (Order1)o;
                            if (!orderReturned.equals(o3)) {
                                this.logErr("Expected:" + o3 + ", actual:" + orderReturned);
                            } else {
                                this.logTrace("Received expected order");
                                ++passCounter;
                            }
                            if (orderReturned.getItem() != i3) {
                                this.logErr("Expected:" + i3 + ", actual:" + orderReturned.getItem());
                                continue;
                            }
                            this.logTrace("Received expected item");
                            ++passCounter;
                            continue;
                        }
                        if (o instanceof Item) {
                            Item item = (Item)o;
                            if (item != i3) {
                                this.logErr("Expected:" + i3 + ", actual:" + item);
                                continue;
                            }
                            this.logTrace("Received expected item");
                            ++passCounter;
                            continue;
                        }
                        this.logErr("Received unexpected object:" + o);
                    }
                }
            }
            if (passCounter == 3) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("nativeQueryTest3 failed");
        }
    }

    public void nativeQueryColumnResultTypeTest() throws Exception {
        boolean pass = false;
        int passCounter = 0;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create Items");
            Item i1 = new Item(7, "Loafers");
            Item i2 = new Item(8, "High Heels");
            Item i3 = new Item(9, "Socks");
            this.logTrace("Create Orders");
            Order1 o7 = new Order1(7, 25.0);
            o7.setItem(i1);
            this.getEntityManager().persist((Object)o7);
            Order1 o8 = new Order1(8, 125.0);
            o8.setItem(i2);
            this.getEntityManager().persist((Object)o8);
            Order1 o9 = new Order1(9, 150.0);
            o9.setItem(i3);
            this.getEntityManager().persist((Object)o9);
            this.logTrace("Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.ID AS \"OID\", o.TOTALPRICE AS \"OPRICE\", o.FK1_FOR_ITEM AS \"OITEM\", i.ITEMNAME AS \"INAME\" from ORDER1 o, ITEM i WHERE (o.TOTALPRICE < 100) AND (o.FK1_FOR_ITEM = i.ID)", "Order4ItemResults").getResultList();
            if (q.size() != 1) {
                this.logErr(" Did not get expected results.  Expected: 1, got: " + q.size());
            } else {
                this.logTrace("Expected size received, verify contents . . . ");
                for (Object obj : q) {
                    Object[] objectArray;
                    if (!(obj instanceof Object[])) continue;
                    for (Object o : objectArray = (Object[])obj) {
                        if (o instanceof Order1) {
                            Order1 orderReturned = (Order1)o;
                            if (!orderReturned.equals(o7)) {
                                this.logErr("Expected:" + o7 + ", actual:" + orderReturned);
                            } else {
                                this.logTrace("Received expected order");
                                ++passCounter;
                            }
                            if (orderReturned.getItem() != i1) {
                                this.logErr("Expected:" + i1 + ", actual:" + orderReturned.getItem());
                                continue;
                            }
                            this.logTrace("Received expected item");
                            ++passCounter;
                            continue;
                        }
                        if (o instanceof String) {
                            String itemName = (String)o;
                            if (!itemName.equals(i1.getItemName())) {
                                this.logErr("Expected:" + i1.getItemName() + ", actual:" + itemName);
                                continue;
                            }
                            this.logTrace("Received expected itemName");
                            ++passCounter;
                            continue;
                        }
                        this.logErr("Received unexpected object:" + o);
                    }
                }
            }
            if (passCounter == 3) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("nativeQueryColumnResultTypeTest failed");
        }
    }

    public void nativeQueryTestConstructorResult() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create Items");
            Item i1 = new Item(7, "Loafers");
            Item i2 = new Item(8, "High Heels");
            Item i3 = new Item(9, "Socks");
            this.logTrace("Create Orders");
            Order1 o7 = new Order1(7, 25.0);
            o7.setItem(i1);
            this.getEntityManager().persist((Object)o7);
            Order1 o8 = new Order1(8, 125.0);
            o8.setItem(i2);
            this.getEntityManager().persist((Object)o8);
            Order1 o9 = new Order1(9, 150.0);
            o9.setItem(i3);
            this.getEntityManager().persist((Object)o9);
            this.logTrace("Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.ID AS \"OID\", o.TOTALPRICE AS \"OPRICE\", i.ITEMNAME AS \"OITEMNAME\" from ORDER1 o, ITEM i WHERE (o.TOTALPRICE < 100) AND (o.FK1_FOR_ITEM = i.ID)", "Order5ItemResults").getResultList();
            if (q.size() != 1) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + q.size());
            } else {
                this.logTrace("Expected size received, verify contents . . . ");
                Order2 o = (Order2)q.get(0);
                if (o.getId() == o7.getId()) {
                    if (o.getTotalPrice() == o7.getTotalPrice()) {
                        if (o.getItemName().equals(o7.getItem().getItemName())) {
                            pass = true;
                        } else {
                            this.logErr("Expected:" + o7.getItem().getItemName() + ", actual:" + o.getItemName());
                        }
                    } else {
                        this.logErr("Expected:" + o7.getTotalPrice() + ", actual:" + o.getTotalPrice());
                    }
                } else {
                    this.logErr("Expected:" + o7.getId() + ", actual:" + o.getId());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("nativeQueryTestConstructorResult failed");
        }
    }

    public void nativeQueryTestConstructorResultWithId() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create Purchase Orders");
            PurchaseOrder p1 = new PurchaseOrder(7, 25);
            this.getEntityManager().persist((Object)p1);
            PurchaseOrder p2 = new PurchaseOrder(8, 50);
            this.getEntityManager().persist((Object)p2);
            PurchaseOrder p3 = new PurchaseOrder(9, 75);
            this.getEntityManager().persist((Object)p3);
            this.logTrace("Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.ID AS \"OID\", o.TOTAL AS \"PTOTAL\" from PURCHASE_ORDER o WHERE (o.TOTAL < 50)", "PurchaseOrder1Results").getResultList();
            if (q.size() != 1) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + q.size());
            } else {
                this.logTrace("Expected size received, verify contents . . . ");
                PurchaseOrder p = (PurchaseOrder)q.get(0);
                if (p.getId() == p1.getId()) {
                    if (p.getTotal() == p1.getTotal()) {
                        pass1 = true;
                    } else {
                        this.logErr("Expected:" + p1.getTotal() + ", actual:" + p.getTotal());
                    }
                } else {
                    this.logErr("Expected: " + p1.getId() + ", actual:" + p.getId());
                }
                if (!this.getEntityManager().contains((Object)p)) {
                    this.logMsg("Entity contains id and is managed.");
                    pass2 = true;
                } else {
                    this.logErr("Entity contains an id and is not managed.");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("nativeQueryTestConstructorResultWithId failed");
        }
    }

    public void nativeQueryTestConstructorResultNoId() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create Purchase Orders");
            PurchaseOrder p1 = new PurchaseOrder(7, 25);
            this.getEntityManager().persist((Object)p1);
            PurchaseOrder p2 = new PurchaseOrder(8, 50);
            this.getEntityManager().persist((Object)p2);
            PurchaseOrder p3 = new PurchaseOrder(9, 75);
            this.getEntityManager().persist((Object)p3);
            this.logTrace("Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select o.TOTAL AS \"PTOTAL\" from PURCHASE_ORDER o WHERE (o.TOTAL < 50)", "PurchaseOrder2Results").getResultList();
            if (q.size() != 1) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + q.size());
            } else {
                this.logTrace("Expected size received, verify contents . . . ");
                PurchaseOrder p = (PurchaseOrder)q.get(0);
                if (p.getId() == 0) {
                    if (p.getTotal() == p1.getTotal()) {
                        pass1 = true;
                    } else {
                        this.logErr("Expected:" + p1.getTotal() + ", actual:" + p.getTotal());
                    }
                } else {
                    this.logErr("Expected: 0, actual:" + p.getId());
                }
                if (!this.getEntityManager().contains((Object)p)) {
                    this.logMsg("Entity does not contain id and is detached.");
                    pass2 = true;
                } else {
                    this.logErr("Entity does not contain an id and is not detached.");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("nativeQueryTestConstructorResultNoId failed");
        }
    }

    public void createNativeQueryStringTest() throws Exception {
        boolean pass = false;
        List q = null;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(2);
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            this.logTrace("Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            this.logTrace("Execute Query");
            q = this.getEntityManager().createNativeQuery("Select o.ID from ORDER1 o WHERE o.ID = 2 ").getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Object o : q) {
                actual.add(this.convertToInt(o));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                this.logTrace("Received expected results");
                pass = true;
            } else {
                this.logErr("Did not get expected results");
                for (Integer i : expected) {
                    this.logErr("expected:" + i);
                }
                for (Integer i : actual) {
                    this.logErr("actual:" + i);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("createNativeQueryStringTest failed");
        }
    }

    public void createNativeQueryResultClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            this.logTrace("Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            this.logTrace("Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select * from ORDER1 o WHERE o.ID = 2 ", Order1.class).getResultList();
            if (q.size() != 1) {
                this.logErr(" Did not get expected results.  Expected: 1, got: " + q.size());
            } else {
                int id = ((Order1)q.get(0)).getId();
                if (id != 2) {
                    this.logErr("id expected:2, actual:" + id);
                } else {
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("createNativeQueryResultClassTest failed");
        }
    }

    public void createNativeQueryResultClassTQTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            this.logTrace("Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            this.logTrace("Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select * from ORDER1 o WHERE o.ID = 2 ", Order1.class).getResultList();
            if (q.size() != 1) {
                this.logErr(" Did not get expected results.  Expected: 1, got: " + q.size());
            } else {
                int id = ((Order1)q.get(0)).getId();
                if (id != 2) {
                    this.logErr("id expected:2, actual:" + id);
                } else {
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("createNativeQueryResultClassTQTest failed");
        }
    }

    public void executeUpdateTransactionRequiredExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityManager().createNativeQuery("Delete from ORDER1").executeUpdate();
            this.logErr("TransactionRequiredException was not thrown");
        }
        catch (TransactionRequiredException ise) {
            this.logTrace("Received expected TransactionRequiredException");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("executeUpdateTransactionRequiredExceptionTest failed");
        }
    }

    public void setParameterTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            this.logTrace("Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            this.logTrace("Execute Query");
            List q = this.getEntityManager().createNativeQuery("Select * from ORDER1 o WHERE o.ID = ? ", Order1.class).setParameter(1, (Object)2).getResultList();
            if (q.size() != 1) {
                this.logErr(" Did not get expected results.  Expected: 1, got: " + q.size());
            } else {
                int id = ((Order1)q.get(0)).getId();
                if (id != 2) {
                    this.logErr("id expected:2, actual:" + id);
                } else {
                    this.logTrace("Received expected result");
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("setParameterTest failed");
        }
    }

    public void getSingleResultTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create Items");
            Item i1 = new Item(1, "Boots");
            Item i2 = new Item(2, "Sneakers");
            Item i3 = new Item(3, "Slippers");
            this.logTrace("Create Orders");
            Order1 o1 = new Order1(1, 25.0);
            o1.setItem(i1);
            this.getEntityManager().persist((Object)o1);
            Order1 o2 = new Order1(2, 125.0);
            o2.setItem(i2);
            this.getEntityManager().persist((Object)o2);
            Order1 o3 = new Order1(3, 150.0);
            o3.setItem(i3);
            this.getEntityManager().persist((Object)o3);
            this.logTrace("Execute Query");
            Object q = this.getEntityManager().createNativeQuery("Select COUNT(*) from ORDER1 o").getSingleResult();
            int i = 0;
            i = this.convertToInt(q);
            if (i == 3) {
                this.logTrace("Received expected result:" + i);
                pass = true;
            } else {
                this.logErr("Expected: 3, actual:" + i);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("getSingleResultTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete FROM ORDER2").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete FROM ORDER1").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete FROM ITEM").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

