/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.singleton.concurrency.container.annotated;

import com.sun.ts.tests.ejb30.lite.singleton.concurrency.common.BeanBase;
import com.sun.ts.tests.ejb30.lite.singleton.concurrency.common.ConcurrencyIF;
import jakarta.ejb.Lock;
import jakarta.ejb.LockType;
import jakarta.ejb.Singleton;
import java.util.LinkedList;

@Singleton
@Lock(value=LockType.READ)
public class ReadSingletonBean
extends BeanBase
implements ConcurrencyIF {
    private long unlockedSum;
    private long lockedSum;
    private LinkedList<Integer> data = new LinkedList();

    @Override
    @Lock(value=LockType.WRITE)
    public void addToLinkedList(Integer i) {
        this.data.add(i);
    }

    @Override
    @Lock(value=LockType.WRITE)
    public int getLinkedListSizeAndClear() {
        int i = this.data.size();
        this.data.clear();
        return i;
    }

    @Override
    @Lock(value=LockType.WRITE)
    public long getAndResetLockedSum() {
        long result = this.lockedSum;
        this.lockedSum = 0L;
        return result;
    }

    @Override
    @Lock(value=LockType.WRITE)
    public void addLocked(int num) {
        for (int i = 0; i < num; ++i) {
            ++this.lockedSum;
        }
    }

    @Override
    public long getAndResetUnlockedSum() {
        long result = this.unlockedSum;
        this.unlockedSum = 0L;
        return result;
    }

    @Override
    public void addUnlocked(int num) {
        for (int i = 0; i < num; ++i) {
            ++this.unlockedSum;
        }
    }

    @Override
    @Lock(value=LockType.WRITE)
    public void addLockedFromInterceptor(String interceptorName, int num) {
        super.addLockedFromInterceptor(interceptorName, num);
    }

    @Override
    public void addUnlockedFromInterceptor(String interceptorName, int num) {
        super.addUnlockedFromInterceptor(interceptorName, num);
    }

    @Override
    @Lock(value=LockType.WRITE)
    public long getAndResetLockedSumFromInterceptor(String interceptorName) {
        return super.getAndResetLockedSumFromInterceptor(interceptorName);
    }

    @Override
    public long getAndResetUnlockedSumFromInterceptor(String interceptorName) {
        return super.getAndResetUnlockedSumFromInterceptor(interceptorName);
    }
}

