/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.exceptionQueue;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.ArrayList;
import java.util.Properties;

public class ExceptionQueueTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.exceptionQueue.ExceptionQueueTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        ExceptionQueueTests theTests = new ExceptionQueueTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            this.queues = new ArrayList(2);
            this.connections = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                TestUtil.logMsg((String)"Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)"An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void xInvalidDestinationExceptionQTest() throws Exception {
        boolean pass = true;
        QueueBrowser qBrowser = null;
        QueueSender qSender = null;
        QueueReceiver qReceiver = null;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            TestUtil.logTrace((String)"** Close default QueueReceiver **");
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logMsg((String)"Test createBrowser(null)");
            Queue dummy = null;
            try {
                qBrowser = this.tool.getDefaultQueueSession().createBrowser(dummy);
                if (qBrowser != null) {
                    TestUtil.logTrace((String)("qBrowser=" + qBrowser));
                }
                TestUtil.logTrace((String)"FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    this.logTrace("Pass: InvalidDestinationException thrown as expected");
                }
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logMsg((String)"Test createBrowser(null),selector");
            try {
                qBrowser = this.tool.getDefaultQueueSession().createBrowser(dummy, "TEST");
                if (qBrowser != null) {
                    TestUtil.logTrace((String)("qBrowser=" + qBrowser));
                }
                TestUtil.logTrace((String)"FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    this.logTrace("Pass: InvalidDestinationException thrown as expected");
                }
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logMsg((String)"Test createReceiver(null)");
            try {
                qReceiver = this.tool.getDefaultQueueSession().createReceiver(dummy);
                if (qReceiver != null) {
                    TestUtil.logTrace((String)("qReceiver=" + qReceiver));
                }
                TestUtil.logTrace((String)"FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    this.logTrace("Pass: InvalidDestinationException thrown as expected");
                }
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logMsg((String)"Test createReceiver(null,selector)");
            try {
                qReceiver = this.tool.getDefaultQueueSession().createReceiver(dummy, "TEST");
                if (qReceiver != null) {
                    TestUtil.logTrace((String)("qReceiver=" + qReceiver));
                }
                TestUtil.logTrace((String)"FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    this.logTrace("Pass: InvalidDestinationException thrown as expected");
                }
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logMsg((String)"Test createSender(null) - null is valid here ");
            try {
                qSender = this.tool.getDefaultQueueSession().createSender(dummy);
                if (qSender != null) {
                    TestUtil.logTrace((String)("qSender=" + qSender));
                }
                TestUtil.logTrace((String)"PASS: ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during xInvalidDestinationExceptionQTest tests");
            }
        }
        catch (Exception e) {
            throw new Exception("xInvalidDestinationExceptionQTest", e);
        }
    }

    public void xMessageNotReadableExceptionQueueTest() throws Exception {
        try {
            BytesMessage msg = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            msg = this.tool.getDefaultQueueSession().createBytesMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionQueueTest");
            try {
                msg.readByte();
                TestUtil.logTrace((String)"FAIL --- should not have gotten this far!");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageNotReadableException occurred!");
                TestUtil.logTrace((String)(" " + nr.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.logTrace((String)"Expected MessageNotReadableException did not occur!");
            throw new Exception("xMessageNotReadableExceptionQueueTest test failed", e);
        }
    }

    public void xMessageNotWriteableExceptionQTestforTextMessage() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionQTestforTextMessage");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            this.logTrace("Got message - OK");
            try {
                messageReceived.setText("testing...");
            }
            catch (MessageNotWriteableException nr) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageNotWriteableException occurred!");
                TestUtil.logTrace((String)(" " + nr.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionQTestforTextMessage");
        }
    }

    public void xMessageNotWriteableExceptionQTestforBytesMessage() throws Exception {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionQTestforBytesMessage");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            this.logTrace("Got message - OK");
            try {
                messageReceived.writeByte(bValue);
            }
            catch (MessageNotWriteableException nr) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageNotWriteableException occurred!");
                TestUtil.logTrace((String)(" " + nr.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionQTestforBytesMessage", e);
        }
    }

    public void xMessageNotWriteableExceptionQTestforStreamMessage() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionQTestforStreamMessage");
            messageSent.writeString("Testing...");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            this.logTrace("Got message - OK");
            try {
                messageReceived.writeString("Testing...");
            }
            catch (MessageNotWriteableException nr) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageNotWriteableException occurred!");
                TestUtil.logTrace((String)(" " + nr.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionQTestforStreamMessage", e);
        }
    }

    public void xMessageNotWriteableExceptionQTestforMapMessage() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionQTestforMapMessage");
            messageSent.setString("aString", "value");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            this.logTrace("Got message - OK");
            try {
                messageReceived.setString("aString", "value");
            }
            catch (MessageNotWriteableException nr) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageNotWriteableException occurred!");
                TestUtil.logTrace((String)(" " + nr.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionQTestforMapMessage", e);
        }
    }

    public void xNullPointerExceptionQueueTest() throws Exception {
        try {
            BytesMessage msg = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            msg = this.tool.getDefaultQueueSession().createBytesMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "xNullPointerExceptionQueueTest");
            msg.writeBytes(null);
        }
        catch (NullPointerException nullp) {
            TestUtil.logTrace((String)"Passed.\n");
            TestUtil.logTrace((String)"NullPointerException occurred!");
            TestUtil.logTrace((String)(" " + nullp.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.logTrace((String)"Expected NullPointerException did not occur!");
            throw new Exception("xNullPointerExceptionQueueTest");
        }
    }

    public void xMessageEOFExceptionQTestforBytesMessage() throws Exception {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageEOFExceptionQTestforBytesMessage");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            this.logTrace("Got message - OK");
            messageReceived.readByte();
            try {
                messageReceived.readByte();
                TestUtil.logTrace((String)"Failed:  expected MessageEOFException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageEOFException end) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageEOFException occurred!");
                TestUtil.logTrace((String)(" " + end.getMessage()));
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageEOFExceptionQTestforBytesMessage", e);
        }
    }

    public void xMessageEOFExceptionQTestforStreamMessage() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageEOFExceptionQTestforStreamMessage");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            this.logTrace("Got message - OK");
            messageReceived.readByte();
            try {
                messageReceived.readByte();
                TestUtil.logTrace((String)"Failed:  expected MessageEOFException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageEOFException end) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageEOFException occurred!");
                TestUtil.logTrace((String)(" " + end.getMessage()));
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageEOFExceptionQTestforStreamMessage", e);
        }
    }

    public void xMessageFormatExceptionQTestforBytesMessage() throws Exception {
        try {
            BytesMessage messageSent = null;
            Object messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageFormatExceptionQTestforBytesMessage");
            this.logTrace("try to write an invalid object");
            try {
                messageSent.writeObject((Object)this.tool.getDefaultQueueSession());
                TestUtil.logTrace((String)"Failed:  expected MessageEOFException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageFormatException fe) {
                TestUtil.logTrace((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageFormatException occurred!");
                TestUtil.logTrace((String)(" " + fe.getMessage()));
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageFormatExceptionQTestforBytesMessage", e);
        }
    }

    public void xMessageFormatExceptionQTestforStreamMessage() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte[] bValues = new byte[]{127, 0, 3};
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.writeBytes(bValues);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageFormatExceptionQTestforStreamMessage");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            this.logTrace("Got message - OK");
            try {
                messageReceived.readString();
                TestUtil.logTrace((String)"Failed:  expected MessageFormatException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageFormatException fe) {
                TestUtil.logMsg((String)"Passed.\n");
                TestUtil.logTrace((String)"MessageFormatException occurred!");
                TestUtil.logTrace((String)(" " + fe.getMessage()));
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageFormatExceptionQTestforStreamMessage", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xInvalidSelectorExceptionQueueTest() throws Exception {
        try {
            QueueBrowser qBrowser = null;
            QueueReceiver qReceiver = null;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            TestUtil.logTrace((String)"** Close default QueueReceiver **");
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logTrace((String)"Send message to Queue. Text = \"message 1\"");
            TextMessage msg1 = this.tool.getDefaultQueueSession().createTextMessage();
            msg1.setText("message 1");
            msg1.setStringProperty("COM_SUN_JMS_TESTNAME", "xInvalidSelectorExceptionQueueTest");
            this.tool.getDefaultQueueSender().send((Message)msg1);
            try {
                TestUtil.logTrace((String)"call createBrowser with incorrect selector.");
                qBrowser = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue(), "=TEST 'test'");
                TestUtil.logErr((String)"Error --- createBrowser didn't throw expected InvalidSelectorException!");
                pass = false;
            }
            catch (InvalidSelectorException es) {
                TestUtil.logTrace((String)"createBrowser threw expected InvalidSelectorException!");
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)"Error -- Incorrect Exception thrown by createBrowser.", (Throwable)e);
            }
            finally {
                if (qBrowser != null) {
                    try {
                        qBrowser.close();
                    }
                    catch (Exception ee) {
                        TestUtil.logErr((String)"Error -- failed to close qBrowser.", (Throwable)ee);
                    }
                }
            }
            try {
                TestUtil.logTrace((String)"call createReceiver with incorrect selector.");
                qReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "=TEST 'test'");
                if (qReceiver != null) {
                    TestUtil.logTrace((String)("qReceiver=" + qReceiver));
                }
                TestUtil.logErr((String)"Error --- createReceiver didn't throw expected InvalidSelectorException!");
                pass = false;
            }
            catch (InvalidSelectorException es) {
                TestUtil.logMsg((String)"createReceiver threw expected InvalidSelectorException!");
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)"Error -- Incorrect Exception thrown by createReceiver.", (Throwable)e);
            }
            finally {
                if (qReceiver != null) {
                    try {
                        qReceiver.close();
                    }
                    catch (Exception ee) {
                        TestUtil.logErr((String)"Error -- failed to close qReceiver.", (Throwable)ee);
                    }
                }
            }
            if (!pass) {
                throw new Exception("xInvalidSelectorExceptionQueueTest failed!!");
            }
        }
        catch (Exception e) {
            throw new Exception("xInvalidSelectorExceptionQueueTest: ", e);
        }
    }

    public void xIllegalStateExceptionQueueTest() throws Exception {
        boolean passed = false;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logMsg((String)"Calling session.commit(), an illegal operation.");
            try {
                this.tool.getDefaultQueueSession().commit();
            }
            catch (IllegalStateException iStateE) {
                passed = true;
                TestUtil.logMsg((String)"Received jakarta.jms.IllegalStateException -- GOOD");
                TestUtil.logTrace((String)("Exception message: " + iStateE.getMessage()));
            }
            if (!passed) {
                throw new Exception("Did not receive IllegalStateException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xIllegalStateExceptionQueueTest");
        }
    }

    public void xUnsupportedOperationExceptionQTest1() throws Exception {
        try {
            TextMessage messageSent = null;
            boolean pass = true;
            Queue myQueue = null;
            QueueSender qSender = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueSender().close();
            qSender = this.tool.getDefaultQueueSession().createSender(myQueue);
            this.tool.getDefaultQueueConnection().start();
            try {
                messageSent = this.tool.getDefaultQueueSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionQTest1");
                this.logTrace("sending a Text message");
                qSender.send((Message)messageSent);
                pass = false;
                this.logErr("Error: QueueSender.send(Message) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                this.logMsg("Got expected UnsupportedOperationException from QueueSender.send(Message)");
            }
            catch (Exception e) {
                this.logErr("Error: QueueSender.send(Message) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                messageSent = this.tool.getDefaultQueueSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionQTest1");
                this.logTrace("sending a Text message");
                qSender.send((Message)messageSent, 2, 4, 0L);
                pass = false;
                this.logErr("Error: QueueSender.send(Message, int, int, long) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                this.logMsg("Got expected UnsupportedOperationException from QueueSender.send(Message, int, int, long)");
            }
            catch (Exception e) {
                this.logErr("Error: QueueSender.send(Message, int, int, long) throw incorrect Exception: ", e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xUnsupportedOperationExceptionQTest1 Failed!");
            }
        }
        catch (Exception e) {
            this.logErr("xUnsupportedOperationExceptionQTest1 Failed!", e);
            throw new Exception("xUnsupportedOperationExceptionQTest1 Failed!", e);
        }
        finally {
            try {
                if (this.tool.getDefaultQueueConnection() != null) {
                    this.tool.flushQueue();
                    this.tool.getDefaultQueueConnection().close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception closing QueueConnection and cleanup", (Throwable)e);
            }
        }
    }

    public void xUnsupportedOperationExceptionQTest2() throws Exception {
        try {
            TextMessage messageSent = null;
            boolean pass = true;
            Destination myDest = null;
            MessageProducer mSender = null;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            mSender = this.tool.getDefaultSession().createProducer(myDest);
            this.tool.getDefaultConnection().start();
            try {
                messageSent = this.tool.getDefaultSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionQTest2");
                this.logTrace("sending a Text message");
                mSender.send((Message)messageSent);
                pass = false;
                this.logErr("Error: MessageProducer.send(Message) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                this.logMsg("Got expected UnsupportedOperationException from MessageProducer.send(Message)");
            }
            catch (Exception e) {
                this.logErr("Error: MessageProducer.send(Message) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                messageSent = this.tool.getDefaultSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionQTest2");
                this.logTrace("sending a Text message");
                mSender.send((Message)messageSent, 2, 4, 0L);
                pass = false;
                this.logErr("Error: MessageProducer.send(Message, int, int, long) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                this.logMsg("Got expected UnsupportedOperationException from MessageProducer.send(Message, int, int, long)");
            }
            catch (Exception e) {
                this.logErr("Error: MessageProducer.send(Message, int, int, long) throw incorrect Exception: ", e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xUnsupportedOperationExceptionQTest2 Failed!");
            }
        }
        catch (Exception e) {
            this.logErr("xUnsupportedOperationExceptionQTest2 Failed!", e);
            throw new Exception("xUnsupportedOperationExceptionQTest2 Failed!", e);
        }
        finally {
            try {
                if (this.tool.getDefaultConnection() != null) {
                    this.tool.flushDestination();
                    this.tool.getDefaultConnection().close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception closing Connection and cleanup", (Throwable)e);
            }
        }
    }

    public void xUnsupportedOperationExceptionQTest3() throws Exception {
        try {
            TextMessage messageSent = null;
            boolean pass = true;
            Destination myDest = null;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            try {
                messageSent = this.tool.getDefaultSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionQTest3");
                this.logTrace("get the second Destination");
                myDest = this.tool.getQueueDestination("MY_QUEUE2");
                this.logTrace("sending a Text message");
                this.tool.getDefaultProducer().send(myDest, (Message)messageSent);
                pass = false;
                this.logErr("Error: MessageProducer.send(Destination, Message) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                this.logMsg("Got expected UnsupportedOperationException from MessageProducer.send(Destination, Message)");
            }
            catch (Exception e) {
                this.logErr("Error: MessageProducer.send(Destination, Message) throw incorrect Exception: ", e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xUnsupportedOperationExceptionQTest3 Failed!");
            }
        }
        catch (Exception e) {
            this.logErr("xUnsupportedOperationExceptionQTest3 Failed!", e);
            throw new Exception("xUnsupportedOperationExceptionQTest3 Failed!", e);
        }
        finally {
            try {
                if (this.tool.getDefaultConnection() != null) {
                    this.tool.flushDestination();
                    this.tool.getDefaultConnection().close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception closing Connection and cleanup", (Throwable)e);
            }
        }
    }

    public void xInvalidDestinationExceptionQTests() throws Exception {
        try {
            boolean pass = true;
            Destination dummy = null;
            Queue dummyQ = null;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            try {
                this.tool.getDefaultSession().createConsumer(dummy);
                this.logErr("Error: createConsumer(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'");
                this.logErr("Error: createConsumer(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null, String)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null, String) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'", true);
                this.logErr("Error: createConsumer(null, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null, String, true)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null, String, true) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createBrowser(dummyQ);
                this.logErr("Error: createBrowser(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createBrowser(null)");
            }
            catch (Exception e) {
                this.logErr("Error: createBrowser(null) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createBrowser(dummyQ, "TEST = 'test'");
                this.logErr("Error: createBrowser(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createBrowser(null, String)");
            }
            catch (Exception e) {
                this.logErr("Error: createBrowser(null, String) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing the default Connection", ex);
            }
            if (!pass) {
                throw new Exception("xInvalidDestinationExceptionQTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xInvalidDestinationExceptionQTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void xMessageNotReadableExceptionQBytesMsgTest() throws Exception {
        try {
            BytesMessage messageSent = null;
            boolean pass = true;
            boolean booleanValue = false;
            byte byteValue = 127;
            byte[] bytesValue = new byte[]{127, -127, 1, 0};
            byte[] bytesValueRecvd = new byte[]{0, 0, 0, 0};
            char charValue = 'Z';
            double doubleValue = 6.02E23;
            float floatValue = 6.02E23f;
            int intValue = Integer.MAX_VALUE;
            long longValue = Long.MAX_VALUE;
            Integer nInteger = new Integer(Integer.MIN_VALUE);
            short shortValue = Short.MIN_VALUE;
            String utfValue = "what";
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionQBytesMsgTest");
            this.logMsg("Writing one of each primitive type to the message");
            messageSent.writeBoolean(booleanValue);
            messageSent.writeByte(byteValue);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(doubleValue);
            messageSent.writeFloat(floatValue);
            messageSent.writeInt(intValue);
            messageSent.writeLong(longValue);
            messageSent.writeObject((Object)nInteger);
            messageSent.writeShort(shortValue);
            messageSent.writeUTF(utfValue);
            messageSent.writeBytes(bytesValue);
            messageSent.writeBytes(bytesValue, 0, 1);
            try {
                messageSent.getBodyLength();
                pass = false;
                TestUtil.logErr((String)"Error: getBodyLength didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"getBodyLength threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"getBodyLength threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBoolean();
                pass = false;
                TestUtil.logErr((String)"Error: readBoolean didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readBoolean threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readBoolean threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readByte();
                pass = false;
                TestUtil.logErr((String)"Error: readByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUnsignedByte();
                pass = false;
                TestUtil.logErr((String)"Error: readUnsignedByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readUnsignedByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readUnsignedByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readShort();
                pass = false;
                TestUtil.logErr((String)"Error: readShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUnsignedShort();
                pass = false;
                TestUtil.logErr((String)"Error: readUnsignedShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readUnsignedShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readUnsignedShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readChar();
                pass = false;
                TestUtil.logErr((String)"Error: readChar didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readChar threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readChar threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readInt();
                pass = false;
                TestUtil.logErr((String)"Error: readInt didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readInt threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readInt threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readLong();
                pass = false;
                TestUtil.logErr((String)"Error: readLong didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readLong threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readLong threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readFloat();
                pass = false;
                TestUtil.logErr((String)"Error: readFloat didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readFloat threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readFloat threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readDouble();
                pass = false;
                TestUtil.logErr((String)"Error: readDouble didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readDouble threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readDouble threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUTF();
                pass = false;
                TestUtil.logErr((String)"Error: readUTF didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readUTF threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readUTF threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBytes(bytesValueRecvd);
                pass = false;
                TestUtil.logErr((String)"Error: readBytes(byte[]) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readBytes(byte[]) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readBytes(byte[]) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBytes(bytesValueRecvd, 1);
                pass = false;
                TestUtil.logErr((String)"Error: readBytes(byte[], int) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readBytes(byte[], int) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readBytes(byte[],int) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xMessageNotReadableExceptionQBytesMsgTest Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotReadableExceptionQBytesMsgTest:");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void xMessageNotReadableExceptionQStreamMsgTest() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            boolean pass = true;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            byte[] bValuesReturned = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionQStreamMsgTest");
            this.logTrace("");
            this.logMsg("Writing one of each primitive type to the message");
            messageSent.writeBytes(bValues2, 0, bValues.length);
            messageSent.writeBoolean(abool);
            messageSent.writeByte(bValue);
            messageSent.writeBytes(bValues);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(dValue);
            messageSent.writeFloat(fValue);
            messageSent.writeInt(iValue);
            messageSent.writeLong(lValue);
            messageSent.writeObject((Object)sTesting);
            messageSent.writeShort(sValue);
            messageSent.writeString(myString);
            messageSent.writeObject(null);
            this.logTrace("Sending message");
            this.tool.getDefaultProducer().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            TestUtil.logTrace((String)"call ClearBody()");
            messageReceived.clearBody();
            try {
                messageReceived.readBoolean();
                pass = false;
                TestUtil.logErr((String)"Error: readBoolean didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readBoolean threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readBoolean threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readByte();
                pass = false;
                TestUtil.logErr((String)"Error: readByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readShort();
                pass = false;
                TestUtil.logErr((String)"Error: readShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readChar();
                pass = false;
                TestUtil.logErr((String)"Error: readChar didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readChar threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readChar threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readInt();
                pass = false;
                TestUtil.logErr((String)"Error: readInt didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readInt threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readInt threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readLong();
                pass = false;
                TestUtil.logErr((String)"Error: readLong didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readLong threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readLong threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readFloat();
                pass = false;
                TestUtil.logErr((String)"Error: readFloat didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readFloat threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readFloat threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readDouble();
                pass = false;
                TestUtil.logErr((String)"Error: readDouble didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readDouble threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readDouble threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readString();
                pass = false;
                TestUtil.logErr((String)"Error: readString didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readString threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readString threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readBytes(bValuesReturned);
                pass = false;
                TestUtil.logErr((String)"Error: readBytes(byte[]) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readBytes(byte[]) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readBytes(byte[]) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readObject();
                pass = false;
                TestUtil.logErr((String)"Error: readObject didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                TestUtil.logTrace((String)"readObject threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"readObject threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xMessageNotReadableExceptionQStreamMsgTest Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotReadableExceptionQStreamMsgTest:");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void xIllegalStateExceptionTestTopicMethodsQ() throws Exception {
        try {
            boolean pass = true;
            Topic myTopic = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            myTopic = this.tool.createNewTopic("MY_TOPIC");
            try {
                this.tool.getDefaultQueueSession().createDurableSubscriber(myTopic, "cts");
                pass = false;
                TestUtil.logErr((String)"Error: QueueSession.createDurableSubscriber(Topic, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.createDurableSubscriber(Topic, String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: QueueSession.createDurableSubscriber(Topic, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultQueueSession().createDurableSubscriber(myTopic, "cts", "TEST = 'test'", false);
                pass = false;
                TestUtil.logErr((String)"Error: QueueSession.createDurableSubscriber(Topic, String, String, boolean) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.createDurableSubscriber(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: QueueSession.createDurableSubscriber(Topic, String, String, boolean) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultQueueSession().createTemporaryTopic();
                pass = false;
                TestUtil.logErr((String)"Error: QueueSession.createTemporayTopic() didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.createTemporayTopic()");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: QueueSession.createTemporayTopic() throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultQueueSession().createTopic("foo");
                pass = false;
                TestUtil.logErr((String)"Error: QueueSession.createTopic(String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.createTopic(String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: QueueSession.createTopic(String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultQueueSession().unsubscribe("foo");
                pass = false;
                TestUtil.logErr((String)"Error: QueueSession.unsubscribe(String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.unsubscribe(String)");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: QueueSession.unsubscribe(String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xIllegalStateExceptionTestTopicMethodsQ Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xIllegalStateExceptionTestTopicMethodsQ");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Error closing Connection", (Throwable)ex);
            }
        }
    }

    public void xIllegalStateExceptionTestRollbackQ() throws Exception {
        try {
            TextMessage messageSent = null;
            Object messageReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xIllegalStateExceptionTestRollbackQ");
            this.logTrace("Sending message to a Queue");
            this.tool.getDefaultProducer().send((Message)messageSent);
            try {
                this.logTrace("Rolling back a non-transacted session must throw IllegalStateException");
                this.tool.getDefaultSession().rollback();
                pass = false;
                TestUtil.logErr((String)"Error: QueueSession.rollback() didn't throw expected IllegalStateException");
            }
            catch (IllegalStateException en) {
                TestUtil.logMsg((String)"Got expected IllegalStateException from QueueSession.rollback()");
            }
            if (!pass) {
                throw new Exception("xIllegalStateExceptionTestRollbackQ");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xIllegalStateExceptionTestRollbackQ");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
                this.tool.flushDestination();
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Error closing Connection", (Throwable)ex);
            }
        }
    }
}

