/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.internal;

import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.interceptor.InvocationContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;

public class AsynchronousScheduledAction
implements Runnable {
    private final InvocationContext context;
    private final CompletableFuture<Object> future;
    private ScheduledFuture<?> scheduledFuture;

    public AsynchronousScheduledAction(InvocationContext context, CompletableFuture<Object> future) {
        this.context = context;
        this.future = future;
    }

    @Override
    public void run() {
        Asynchronous.Result.setFuture(this.future);
        boolean cancelScheduler = false;
        try {
            CompletableFuture returnedFuture = (CompletableFuture)this.context.proceed();
            if (returnedFuture != null && this.scheduledFuture != null) {
                cancelScheduler = true;
            }
        }
        catch (Exception e) {
            this.future.completeExceptionally(e);
        }
        finally {
            Asynchronous.Result.setFuture(null);
            if (this.future.isDone() || this.future.isCompletedExceptionally() || this.future.isCancelled()) {
                cancelScheduler = true;
            }
        }
        if (cancelScheduler) {
            this.scheduledFuture.cancel(false);
        }
    }

    public void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }
}

