/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.util.Vector;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.MemberDefinition;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.Node;

public class LocalMember
extends MemberDefinition {
    int number = -1;
    int readcount;
    int writecount;
    int scopeNumber;
    LocalMember originalOfCopy;
    LocalMember prev;

    public int getScopeNumber() {
        return this.scopeNumber;
    }

    public LocalMember(long where, ClassDefinition clazz, int modifiers, Type type, Identifier name) {
        super(where, clazz, modifiers, type, name, null, null);
    }

    public LocalMember(ClassDefinition innerClass) {
        super(innerClass);
        this.name = innerClass.getLocalName();
    }

    LocalMember(MemberDefinition field) {
        this(0L, null, 0, field.getType(), idClass);
        this.accessPeer = field;
    }

    final MemberDefinition getMember() {
        return this.name == idClass ? this.accessPeer : null;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public LocalMember copyInline(Context ctx) {
        LocalMember copy = new LocalMember(this.where, this.clazz, this.modifiers, this.type, this.name);
        copy.readcount = this.readcount;
        copy.writecount = this.writecount;
        copy.originalOfCopy = this;
        copy.addModifiers(131072);
        if (this.accessPeer != null && (this.accessPeer.getModifiers() & 0x20000) == 0) {
            throw new CompilerError("local copyInline");
        }
        this.accessPeer = copy;
        return copy;
    }

    public LocalMember getCurrentInlineCopy(Context ctx) {
        MemberDefinition accessPeer = this.accessPeer;
        if (accessPeer != null && (accessPeer.getModifiers() & 0x20000) != 0) {
            LocalMember copy = (LocalMember)accessPeer;
            return copy;
        }
        return this;
    }

    public static LocalMember[] copyArguments(Context ctx, MemberDefinition field) {
        Vector<MemberDefinition> v = field.getArguments();
        Object[] res = new LocalMember[v.size()];
        v.copyInto(res);
        for (int i = 0; i < res.length; ++i) {
            res[i] = ((LocalMember)res[i]).copyInline(ctx);
        }
        return res;
    }

    public static void doneWithArguments(Context ctx, LocalMember[] res) {
        for (int i = 0; i < res.length; ++i) {
            if (res[i].originalOfCopy.accessPeer != res[i]) continue;
            res[i].originalOfCopy.accessPeer = null;
        }
    }

    @Override
    public boolean isInlineable(Environment env, boolean fromFinal) {
        return (this.getModifiers() & 0x100000) != 0;
    }

    public boolean isUsed() {
        return this.readcount != 0 || this.writecount != 0;
    }

    LocalMember getAccessVar() {
        return (LocalMember)this.accessPeer;
    }

    void setAccessVar(LocalMember f) {
        this.accessPeer = f;
    }

    MemberDefinition getAccessVarMember() {
        return this.accessPeer;
    }

    void setAccessVarMember(MemberDefinition f) {
        this.accessPeer = f;
    }

    @Override
    public Node getValue(Environment env) {
        return (Expression)this.getValue();
    }

    public int getNumber(Context ctx) {
        return this.number;
    }
}

