/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.parser;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ResourceLoader;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapMutator;
import com.sun.xml.ws.policy.localization.LocalizationMessages;
import com.sun.xml.ws.policy.parser.PolicyResourceLoader;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public final class PolicyConfigParser {
    private static final Logger LOGGER = Logger.getLogger(PolicyConfigParser.class);
    private static final String SERVLET_CONTEXT_CLASSNAME = "jakarta.servlet.ServletContext";
    private static final String JAR_PREFIX = "META-INF/";
    private static final String WAR_PREFIX = "/WEB-INF/";

    private PolicyConfigParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicyMap parse(String configFileIdentifier, Container container, PolicyMapMutator ... mutators) throws PolicyException {
        PolicyMap policyMap;
        LOGGER.entering(new Object[]{configFileIdentifier, container, mutators});
        PolicyMap map = null;
        try {
            WSDLModel configModel = PolicyConfigParser.parseModel(configFileIdentifier, container, mutators);
            if (configModel != null) {
                map = configModel.getPolicyMap();
            }
            policyMap = map;
        }
        catch (Throwable throwable) {
            LOGGER.exiting(map);
            throw throwable;
        }
        LOGGER.exiting((Object)map);
        return policyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicyMap parse(URL configFileUrl, boolean isClient, PolicyMapMutator ... mutators) throws PolicyException, IllegalArgumentException {
        PolicyMap policyMap;
        LOGGER.entering(new Object[]{configFileUrl, isClient, mutators});
        PolicyMap map = null;
        try {
            policyMap = map = PolicyConfigParser.parseModel(configFileUrl, isClient, mutators).getPolicyMap();
        }
        catch (Throwable throwable) {
            LOGGER.exiting(map);
            throw throwable;
        }
        LOGGER.exiting((Object)map);
        return policyMap;
    }

    public static WSDLModel parseModel(String configFileIdentifier, Container container, PolicyMapMutator ... mutators) throws PolicyException {
        WSDLModel model;
        LOGGER.entering(new Object[]{configFileIdentifier, container, mutators});
        URL configFileUrl = PolicyConfigParser.findConfigFile(configFileIdentifier, container);
        if (configFileUrl != null) {
            model = PolicyConfigParser.parseModel(configFileUrl, "client".equals(configFileIdentifier), mutators);
            LOGGER.info(LocalizationMessages.WSP_5018_LOADED_WSIT_CFG_FILE(configFileUrl.toExternalForm()));
        } else {
            model = null;
        }
        LOGGER.exiting(model);
        return model;
    }

    public static WSDLModel parseModel(URL configFileUrl, boolean isClient, PolicyMapMutator ... mutators) throws PolicyException, IllegalArgumentException {
        LOGGER.entering(new Object[]{configFileUrl, isClient, mutators});
        Object model = null;
        try {
            if (null == configFileUrl) {
                throw (IllegalArgumentException)LOGGER.logSevereException((Throwable)new IllegalArgumentException(LocalizationMessages.WSP_5007_FAILED_TO_READ_NULL_WSIT_CFG()));
            }
            WSDLModel wSDLModel = PolicyResourceLoader.getWsdlModel(configFileUrl, isClient);
            return wSDLModel;
        }
        catch (XMLStreamException ex) {
            throw (PolicyException)LOGGER.logSevereException((Throwable)new PolicyException(LocalizationMessages.WSP_5001_WSIT_CFG_FILE_PROCESSING_FAILED(configFileUrl.toString()), ex));
        }
        catch (IOException ex) {
            throw (PolicyException)LOGGER.logSevereException((Throwable)new PolicyException(LocalizationMessages.WSP_5001_WSIT_CFG_FILE_PROCESSING_FAILED(configFileUrl.toString()), ex));
        }
        catch (SAXException ex) {
            throw (PolicyException)LOGGER.logSevereException((Throwable)new PolicyException(LocalizationMessages.WSP_5001_WSIT_CFG_FILE_PROCESSING_FAILED(configFileUrl.toString()), ex));
        }
        finally {
            LOGGER.exiting(model);
        }
    }

    public static URL findConfigFile(String configFileIdentifier, Container container) throws PolicyException {
        URL configFileUrl;
        String configFileName = PolicyUtils.ConfigFile.generateFullName(configFileIdentifier);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(LocalizationMessages.WSP_5011_CONFIG_FILE_IS(configFileName));
        }
        WsitConfigResourceLoader loader = new WsitConfigResourceLoader(container);
        try {
            configFileUrl = loader.getResource(configFileName);
        }
        catch (MalformedURLException e) {
            throw (PolicyException)LOGGER.logSevereException((Throwable)new PolicyException(LocalizationMessages.WSP_5021_FAILED_RESOURCE_FROM_LOADER(configFileName, loader), e));
        }
        return configFileUrl;
    }

    private static class WsitConfigResourceLoader
    extends ResourceLoader {
        Container container;
        ResourceLoader parentLoader;

        WsitConfigResourceLoader(ResourceLoader parentLoader) {
            this.parentLoader = parentLoader;
        }

        WsitConfigResourceLoader(Container container) {
            this(container != null ? container.getSPI(ResourceLoader.class) : null);
            this.container = container;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL getResource(String resource) throws MalformedURLException {
            URL uRL;
            LOGGER.entering(new Object[]{resource});
            URL resourceUrl = null;
            try {
                if (this.parentLoader != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(LocalizationMessages.WSP_5020_RESOURCE_FROM_LOADER(resource, this.parentLoader));
                    }
                    resourceUrl = this.parentLoader.getResource(resource);
                }
                if (resourceUrl == null && this.container != null) {
                    Object context;
                    block13: {
                        context = null;
                        try {
                            Class<?> contextClass = Class.forName(PolicyConfigParser.SERVLET_CONTEXT_CLASSNAME);
                            context = this.container.getSPI(contextClass);
                            if (context != null) {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.fine(LocalizationMessages.WSP_5022_RESOURCE_FROM_CONTEXT(resource, context));
                                }
                                resourceUrl = PolicyUtils.ConfigFile.loadFromContext(PolicyConfigParser.WAR_PREFIX + resource, context);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block13;
                            LOGGER.fine(LocalizationMessages.WSP_5016_CAN_NOT_FIND_CLASS(PolicyConfigParser.SERVLET_CONTEXT_CLASSNAME));
                        }
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest(LocalizationMessages.WSP_5010_CONTEXT_IS(context));
                    }
                }
                if (resourceUrl == null) {
                    StringBuilder examinedPath = new StringBuilder(PolicyConfigParser.JAR_PREFIX).append(resource);
                    resourceUrl = PolicyUtils.ConfigFile.loadFromClasspath(examinedPath.toString());
                    if (resourceUrl == null && this.isClientConfig(resource)) {
                        examinedPath.append(File.pathSeparator).append(resource);
                        resourceUrl = PolicyUtils.ConfigFile.loadFromClasspath(resource);
                    }
                    if (resourceUrl == null && LOGGER.isLoggable(Level.CONFIG)) {
                        LOGGER.config(LocalizationMessages.WSP_5009_COULD_NOT_LOCATE_WSIT_CFG_FILE(resource, examinedPath));
                    }
                }
                uRL = resourceUrl;
            }
            catch (Throwable throwable) {
                LOGGER.exiting(resourceUrl);
                throw throwable;
            }
            LOGGER.exiting((Object)resourceUrl);
            return uRL;
        }

        private boolean isClientConfig(String resource) {
            return "wsit-client.xml".equals(resource);
        }
    }
}

