/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.glassfish.loadbalancer.admin.cli.LBCommandsBase;
import org.glassfish.loadbalancer.config.LbConfig;
import org.glassfish.loadbalancer.config.LbConfigs;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="disable-http-lb-server")
@PerLookup
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="disable-http-lb-server", description="disable-http-lb-server", params={@RestParam(name="id", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="disable-http-lb-server", description="disable-http-lb-server", params={@RestParam(name="id", value="$parent")})})
public final class DisableHTTPLBServerCommand
extends LBCommandsBase
implements AdminCommand {
    @Param(primary=true)
    String target;
    @Param(optional=true, defaultValue="30")
    String timeout;
    @Inject
    Target tgt;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableHTTPLBServerCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        LbConfigs lbconfigs = (LbConfigs)this.domain.getExtensionByType(LbConfigs.class);
        if (lbconfigs == null) {
            String msg = localStrings.getLocalString("NoLbConfigsElement", "Empty lb-configs");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        int t = Integer.parseInt(this.timeout);
        if (t < 0) {
            String msg = localStrings.getLocalString("InvalidTimeout", "Invalid timeout {0}", new Object[]{this.timeout});
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (this.tgt.isCluster(this.target)) {
            this.updateLBForCluster(report, this.target, "false", this.timeout);
        } else {
            boolean foundTarget = false;
            List lbConfigs = lbconfigs.getLbConfig();
            for (LbConfig lc : lbConfigs) {
                ServerRef sRef = (ServerRef)lc.getRefByRef(ServerRef.class, this.target);
                if (sRef == null) {
                    logger.warning(localStrings.getLocalString("InvalidInstance", "Server {0} does not exist in {1}", new Object[]{this.target, lc.getName()}));
                    continue;
                }
                int curTout = Integer.parseInt(sRef.getDisableTimeoutInMinutes());
                boolean enabled = sRef.getLbEnabled().equals("true");
                if (!enabled && curTout == t) {
                    String msg = localStrings.getLocalString("ServerDisabled", "Server [{0}] is already disabled.", new Object[]{sRef.getRef()});
                    report.setMessage(msg);
                    return;
                }
                try {
                    this.updateLbEnabled(sRef, "false", this.timeout);
                }
                catch (TransactionFailure ex) {
                    String msg = localStrings.getLocalString("FailedToUpdateAttr", "Failed to update lb-enabled attribute for {0}", new Object[]{this.target});
                    report.setMessage(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setFailureCause((Throwable)ex);
                    return;
                }
                foundTarget = true;
            }
            if (!foundTarget) {
                ServerRef sRef = this.getServerRefFromCluster(report, this.target);
                if (sRef == null) {
                    String msg = localStrings.getLocalString("InvalidServer", "Server {0} does not exist", new Object[]{this.target});
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    return;
                }
                int curTout = Integer.parseInt(sRef.getDisableTimeoutInMinutes());
                boolean enabled = sRef.getLbEnabled().equals("true");
                if (!enabled && curTout == t) {
                    String msg = localStrings.getLocalString("ServerDisabled", "Server [{0}] is already disabled.", new Object[]{sRef.getRef()});
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    return;
                }
                try {
                    this.updateLbEnabled(sRef, "false", this.timeout);
                }
                catch (TransactionFailure ex) {
                    String msg = localStrings.getLocalString("FailedToUpdateAttr", "Failed to update lb-enabled attribute for {0}", new Object[]{this.target});
                    report.setMessage(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setFailureCause((Throwable)ex);
                    return;
                }
            }
        }
    }
}

