/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.agent;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class GFDependenciesClassLoader
extends URLClassLoader {
    private static final Function<File, URL> TO_URL;
    private static final boolean AS_TRACE;

    GFDependenciesClassLoader() {
        super("GlassFish", GFDependenciesClassLoader.findGlassFishJars(), ClassLoader.getPlatformClassLoader());
    }

    public String toString() {
        StringBuilder text = new StringBuilder(1024);
        text.append(this.getClass().getName()).append('@').append(Integer.toHexString(this.hashCode()));
        text.append("[name=").append(this.getName()).append(']');
        if (AS_TRACE) {
            text.append(", urls=[\n");
            Arrays.stream(this.getURLs()).forEach(u -> text.append(u).append('\n'));
            text.append(']');
            text.append(", parent=").append(this.getParent());
        }
        return text.toString();
    }

    private static URL[] findGlassFishJars() {
        Path gfHome = GFDependenciesClassLoader.getGlassFishHome();
        Path gfModules = gfHome.resolve("modules");
        Set ignoredFiles = Set.of();
        Predicate<Path> moduleFilter = path -> {
            String fileName = path.getFileName().toString();
            if (!fileName.endsWith(".jar") || ignoredFiles.contains(fileName)) {
                return false;
            }
            String relativePath = gfModules.relativize((Path)path).toString();
            return !relativePath.contains("autostart/");
        };
        Path appInstall = gfHome.resolve(Path.of("lib", "install", "applications"));
        Predicate<Path> libFilter = filePath -> {
            String path = appInstall.relativize((Path)filePath).toString();
            return path.endsWith(".jar") && (path.contains("jmsra/") || path.contains("_jdbc_ra/"));
        };
        Path derbyLibDir = gfHome.resolve(Path.of("..", "javadb", "lib")).normalize();
        Predicate<Path> derbyFilter = filePath -> {
            Set<String> files = Set.of("derby.jar", "derbyclient.jar", "derbynet.jar");
            return files.contains(filePath.getFileName().toString());
        };
        Stream<File> modules = GFDependenciesClassLoader.findFiles(gfModules, moduleFilter);
        Stream<File> libs = GFDependenciesClassLoader.findFiles(appInstall, libFilter);
        Stream<File> derbyLibs = GFDependenciesClassLoader.findFiles(derbyLibDir, derbyFilter);
        return (URL[])Stream.of(modules, libs, derbyLibs).reduce(Stream::concat).orElseGet(Stream::empty).map(TO_URL).toArray(URL[]::new);
    }

    private static Stream<File> findFiles(Path root, Predicate<Path> filter) {
        try {
            return Files.walk(root, 5, new FileVisitOption[0]).filter(filter).map(Path::toFile);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static Path getGlassFishHome() {
        return new File(GFDependenciesClassLoader.getMyJar()).getParentFile().getParentFile().toPath();
    }

    private static URI getMyJar() {
        try {
            CodeSource codeSource = GFDependenciesClassLoader.class.getProtectionDomain().getCodeSource();
            if (codeSource == null || codeSource.getLocation() == null) {
                throw new Error("Unable to detect the current jar file location, because the getCodeSource() or getLocation() method returned null. That can happen ie. when you use the boot classloader or a classloader which doesn't use locations.");
            }
            return codeSource.getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new Error("Could not detect the GlassFish lib directory.", e);
        }
    }

    static {
        GFDependenciesClassLoader.registerAsParallelCapable();
        TO_URL = file -> {
            try {
                return file.toURI().toURL();
            }
            catch (IOException e) {
                throw new Error("Could not resolve url: " + String.valueOf(file), e);
            }
        };
        AS_TRACE = Boolean.parseBoolean(System.getenv("AS_TRACE"));
    }
}

