/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.spi.WriterInfo;

class OutputStreamToAsyncBinaryAdapter
extends OutputStream {
    private final TyrusWebSocket socket;
    private static final WriterInfo BINARY_CONTINUATION_INFO = new WriterInfo(WriterInfo.MessageType.BINARY_CONTINUATION, WriterInfo.RemoteEndpointType.BASIC);
    private static final WriterInfo BINARY_INFO = new WriterInfo(WriterInfo.MessageType.BINARY, WriterInfo.RemoteEndpointType.BASIC);

    public OutputStreamToAsyncBinaryAdapter(TyrusWebSocket socket) {
        this.socket = socket;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        Future<Frame> future = this.socket.sendBinary(b, off, len, false, BINARY_CONTINUATION_INFO);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    @Override
    public void write(int i) throws IOException {
        byte[] byteArray = new byte[]{(byte)i};
        this.write(byteArray, 0, byteArray.length);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.socket.sendBinary(new byte[0], true, BINARY_INFO);
    }
}

