/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.weld.util.Preconditions;

class Item
implements Comparable<Item> {
    static final int ITEM_PRIORITY_SCALE_POWER = 10;
    private final Class<?> javaClass;
    private final int originalPriority;
    private final AtomicInteger priority;

    Item(Class<?> javaClass, int priority) {
        this(javaClass, priority, priority);
    }

    Item(Class<?> javaClass, int originalPriority, int priority) {
        Preconditions.checkArgumentNotNull(javaClass, "javaClass");
        Preconditions.checkArgumentNotNull(priority, "priority");
        Preconditions.checkArgumentNotNull(originalPriority, "originalPriority");
        this.javaClass = javaClass;
        this.priority = new AtomicInteger(priority);
        this.originalPriority = originalPriority;
    }

    void scalePriority() {
        this.priority.getAndUpdate(p -> p * 10);
    }

    Class<?> getJavaClass() {
        return this.javaClass;
    }

    int getPriority() {
        return this.priority.get();
    }

    int getOriginalPriority() {
        return this.originalPriority;
    }

    int getNumberOfScaling() {
        int current = this.priority.get();
        if (current == this.originalPriority) {
            return 0;
        }
        int scaling = 0;
        do {
            ++scaling;
        } while ((current /= 10) != this.originalPriority);
        return scaling;
    }

    @Override
    public int compareTo(Item o) {
        int p2;
        int p1 = this.priority.get();
        if (p1 == (p2 = o.priority.get())) {
            return this.javaClass.getName().compareTo(o.javaClass.getName());
        }
        if (p1 < p2) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return this.javaClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Item) {
            Item that = (Item)obj;
            return Objects.equals(this.javaClass, that.javaClass);
        }
        return false;
    }

    public String toString() {
        return "[Class=" + String.valueOf(this.javaClass) + ", priority=" + String.valueOf(this.priority) + "]";
    }
}

