/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectorRARClassLoader;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.main.jdke.cl.GlassfishUrlClassLoader;

public class RARUtils {
    private static final Logger _logger = LogDomains.getLogger(RARUtils.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static StringManager localStrings = StringManager.getManager(RARUtils.class);

    public static boolean isValidRABeanConfigProperty(Class clz) {
        return clz.isPrimitive() || clz.equals(String.class) || RARUtils.isPrimitiveWrapper(clz);
    }

    private static boolean isPrimitiveWrapper(Class clz) {
        return clz.equals(Boolean.class) || clz.equals(Character.class) || clz.equals(Byte.class) || clz.equals(Short.class) || clz.equals(Integer.class) || clz.equals(Long.class) || clz.equals(Float.class) || clz.equals(Double.class);
    }

    public static Set<EnvironmentProperty> getMergedActivationConfigProperties(EjbMessageBeanDescriptor msgDesc) {
        Set standardProps;
        HashSet<EnvironmentProperty> mergedProps = new HashSet<EnvironmentProperty>();
        HashSet<String> runtimePropNames = new HashSet<String>();
        Set runtimeProps = msgDesc.getRuntimeActivationConfigProperties();
        if (runtimeProps != null) {
            for (EnvironmentProperty entry : runtimeProps) {
                mergedProps.add(entry);
                String propName = entry.getName();
                runtimePropNames.add(propName);
            }
        }
        if ((standardProps = msgDesc.getActivationConfigProperties()) != null) {
            for (EnvironmentProperty entry : standardProps) {
                String propName = entry.getName();
                if (runtimePropNames.contains(propName)) continue;
                mergedProps.add(entry);
            }
        }
        return mergedProps;
    }

    public static Class<?> loadClassFromRar(String rarName, String beanClassName) throws ConnectorRuntimeException {
        String rarLocation = RARUtils.getRarLocation(rarName);
        return RARUtils.loadClass(rarLocation, beanClassName);
    }

    private static String getRarLocation(String rarName) throws ConnectorRuntimeException {
        return ConnectorsUtil.getLocation((String)rarName);
    }

    private static Class<?> loadClass(String pathToDeployableUnit, String beanClassName) throws ConnectorRuntimeException {
        Class<?> cls = null;
        ClassLoader cl = RARUtils.getClassLoader(pathToDeployableUnit);
        try {
            if (beanClassName != null && !beanClassName.isBlank()) {
                cls = cl.loadClass(beanClassName);
            }
            return cls;
        }
        catch (ClassNotFoundException e) {
            _logger.info(e.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Unable to find class while trying to read connector descriptor to get resource-adapter properties", e);
            }
            ConnectorRuntimeException cre = new ConnectorRuntimeException("unable to find class : " + beanClassName);
            cre.setStackTrace(e.getStackTrace());
            throw cre;
        }
    }

    private static ClassLoader getClassLoader(String file) throws ConnectorRuntimeException {
        File f = new File(file);
        RARUtils.validateRARLocation(f);
        try {
            ClassLoader commonCL = ConnectorRuntime.getRuntime().getClassLoaderHierarchy().getCommonClassLoader();
            if (f.isDirectory()) {
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(f.toURI().toURL());
                RARUtils.appendURLs(urls, f);
                return new GlassfishUrlClassLoader("ResourceAdapterDir(" + f.getName() + ")", (URL[])urls.toArray(URL[]::new), commonCL);
            }
            return new ConnectorRARClassLoader(file, commonCL);
        }
        catch (IOException ioe) {
            throw new ConnectorRuntimeException("unable to read connector descriptor from " + file, (Throwable)ioe);
        }
    }

    private static void appendURLs(List<URL> urls, File f) throws MalformedURLException {
        File[] files = f.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.getName().toUpperCase(Locale.getDefault()).endsWith(".JAR")) {
                    urls.add(file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                RARUtils.appendURLs(urls, file);
            }
        }
    }

    private static void validateRARLocation(File f) throws ConnectorRuntimeException {
        if (!f.exists()) {
            String i18nMsg = localStrings.getString("rar_archive_not_found", (Object)f);
            throw new ConnectorRuntimeException(i18nMsg);
        }
    }
}

