/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.ServiceUtil;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class ServiceConfig
extends MQMBeanReadWrite
implements ConfigListener {
    private String service = null;
    private Properties brokerProps = null;
    private boolean propsStale = true;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public ServiceConfig(String service) {
        this.service = service;
        this.initProps();
        BrokerConfig cfg = Globals.getConfig();
        cfg.addListener(this.getThreadModelPropName(), this);
        cfg.addListener(this.getMaxThreadsPropName(), this);
        cfg.addListener(this.getMinThreadsPropName(), this);
        cfg.addListener(this.getPortPropName(), this);
    }

    public void setMaxThreads(Integer i) throws MBeanException {
        try {
            this.updateService(-1, -1, i);
        }
        catch (Exception e) {
            this.handleSetterException("MaxThreads", e);
        }
    }

    public Integer getMaxThreads() throws MBeanException {
        this.initProps();
        String s = this.brokerProps.getProperty(this.getMaxThreadsPropName());
        Integer i = null;
        try {
            if (s != null) {
                i = Integer.valueOf(s);
            }
        }
        catch (Exception e) {
            this.handleGetterException("MaxThreads", e);
        }
        return i;
    }

    private String getMaxThreadsPropName() {
        return "imq." + this.getName() + ".max_threads";
    }

    public void setMinThreads(Integer i) throws MBeanException {
        try {
            this.updateService(-1, i, -1);
        }
        catch (Exception e) {
            this.handleSetterException("MinThreads", e);
        }
    }

    public Integer getMinThreads() throws MBeanException {
        this.initProps();
        String s = this.brokerProps.getProperty(this.getMinThreadsPropName());
        Integer i = null;
        try {
            if (s != null) {
                i = Integer.valueOf(s);
            }
        }
        catch (Exception e) {
            this.handleGetterException("MinThreads", e);
        }
        return i;
    }

    private String getMinThreadsPropName() {
        return "imq." + this.getName() + ".min_threads";
    }

    public String getName() {
        return this.service;
    }

    public void setPort(Integer i) throws MBeanException {
        try {
            this.updateService(i, -1, -1);
        }
        catch (Exception e) {
            this.handleSetterException("Port", e);
        }
    }

    public Integer getPort() throws MBeanException {
        this.initProps();
        String s = this.brokerProps.getProperty(this.getPortPropName());
        Integer i = null;
        try {
            if (s != null) {
                i = Integer.valueOf(s);
            }
        }
        catch (Exception e) {
            this.handleGetterException("Port", e);
        }
        return i;
    }

    private String getPortPropName() {
        String proto = this.brokerProps.getProperty("imq." + this.getName() + ".protocoltype");
        return "imq." + this.getName() + "." + proto + ".port";
    }

    public String getThreadPoolModel() {
        return this.brokerProps.getProperty(this.getThreadModelPropName());
    }

    private String getThreadModelPropName() {
        return "imq." + this.getName() + ".threadpool_model";
    }

    public void pause() throws MBeanException {
        try {
            if (this.isAdminService()) {
                throw new BrokerException("Cannot pause admin service: " + this.service);
            }
            this.logger.log(8, "B1124", this.service);
            ServiceUtil.pauseService(this.service);
        }
        catch (BrokerException e) {
            this.handleOperationException("pause", e);
        }
    }

    public void resume() throws MBeanException {
        try {
            if (this.isAdminService()) {
                throw new BrokerException("Cannot resume admin service: " + this.service);
            }
            this.logger.log(8, "B1128", this.service);
            ServiceUtil.resumeService(this.service);
        }
        catch (BrokerException e) {
            this.handleOperationException("resume", e);
        }
    }

    private boolean isAdminService() {
        ServiceInfo si = ServiceUtil.getServiceInfo(this.service);
        if (si == null) {
            return false;
        }
        return si.type == 1;
    }

    @Override
    public String getMBeanName() {
        return "ServiceConfig";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1192");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
    }

    @Override
    public boolean update(String name, String value) {
        Integer newVal = null;
        Integer oldVal = null;
        if (name.equals(this.getMaxThreadsPropName())) {
            try {
                newVal = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of MaxThreads: " + String.valueOf(nfe));
                newVal = null;
            }
            try {
                oldVal = this.getMaxThreads();
            }
            catch (Exception e) {
                this.logProblemGettingOldVal("MaxThreads", e);
                oldVal = null;
            }
            this.notifyAttrChange("MaxThreads", newVal, oldVal);
            this.propsStale = true;
        } else if (name.equals(this.getMinThreadsPropName())) {
            try {
                newVal = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of MinThreads: " + String.valueOf(nfe));
                newVal = null;
            }
            try {
                oldVal = this.getMinThreads();
            }
            catch (Exception e) {
                this.logProblemGettingOldVal("MinThreads", e);
                oldVal = null;
            }
            this.notifyAttrChange("MinThreads", newVal, oldVal);
            this.propsStale = true;
        } else if (name.equals(this.getPortPropName())) {
            try {
                newVal = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of Port: " + String.valueOf(nfe));
                newVal = null;
            }
            try {
                oldVal = this.getPort();
            }
            catch (Exception e) {
                this.logProblemGettingOldVal("Port", e);
                oldVal = null;
            }
            this.notifyAttrChange("Port", newVal, oldVal);
            this.propsStale = true;
        }
        return true;
    }

    public void notifyAttrChange(String attrName, Object newVal, Object oldVal) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", attrName, newVal == null ? "" : newVal.getClass().getName(), oldVal, newVal));
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.notifyServiceAttrUpdated(this.getName(), attrName, oldVal, newVal);
        }
    }

    private void updateService(int port, int min, int max) throws IOException, PropertyUpdateException, BrokerException {
        ServiceManager sm = Globals.getServiceManager();
        Service svc = sm.getService(this.getName());
        if (svc == null) {
            throw new BrokerException(rb.getString("B4057", this.getName()));
        }
        if (!(svc instanceof IMQService)) {
            throw new BrokerException("Internal Error: can updated non-standard Service");
        }
        IMQService stsvc = (IMQService)svc;
        stsvc.updateService(port, min, max);
    }

    private void initProps() {
        if (!this.propsStale) {
            return;
        }
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
        this.propsStale = false;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[5];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("MaxThreads", Integer.class.getName(), mbr.getString("MB1193"), true, true, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("MinThreads", Integer.class.getName(), mbr.getString("MB1194"), true, true, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("Name", String.class.getName(), mbr.getString("MB1195"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("Port", Integer.class.getName(), mbr.getString("MB1196"), true, true, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("ThreadPoolModel", String.class.getName(), mbr.getString("MB1197"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[2];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("pause", mbr.getString("MB1214"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("resume", mbr.getString("MB1215"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

