/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PropertiesFilter {
    static final String KEY_FILTER_PROPERTY = "io.helidon.config.env-filter.key";
    static final String VALUE_FILTER_PROPERTY = "io.helidon.config.env-filter.value";
    static final String USE_DEFAULT_FILTER_PROPERTY = "io.helidon.config.env-filter.use-default";
    static final String SEPARATOR_FILTER_PROPERTY = "io.helidon.config.env-filter.separator";
    private static final String REGEX_BASH_FUNC = "BASH_FUNC_(.*?)%%";
    private static final Pattern PATTERN_BASH_FUNC = Pattern.compile("BASH_FUNC_(.*?)%%");
    private static final List<Pattern> DEFAULT_KEY_PATTERNS = List.of(PATTERN_BASH_FUNC);
    private final List<Pattern> keyFilters;
    private final List<Pattern> valueFilters;

    private PropertiesFilter(List<String> keyFilters, List<String> valueFilters, boolean useDefault) {
        this.keyFilters = this.convert(keyFilters);
        this.valueFilters = this.convert(valueFilters);
        if (useDefault) {
            this.keyFilters.addAll(DEFAULT_KEY_PATTERNS);
        }
    }

    public static PropertiesFilter create(Properties properties) {
        Objects.requireNonNull(properties, "properties are null");
        List<String> keyFilters = PropertiesFilter.parseFilterProperty(KEY_FILTER_PROPERTY, properties);
        List<String> valueFilters = PropertiesFilter.parseFilterProperty(VALUE_FILTER_PROPERTY, properties);
        boolean useDefault = Boolean.parseBoolean(properties.getProperty(USE_DEFAULT_FILTER_PROPERTY, "true"));
        return new PropertiesFilter(keyFilters, valueFilters, useDefault);
    }

    public Map<String, String> filter(Map<String, String> properties) {
        return properties.entrySet().stream().filter((? super T entry) -> this.matches(this.keyFilters, (String)entry.getKey())).filter((? super T entry) -> this.matches(this.valueFilters, (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static List<String> parseFilterProperty(String property, Properties properties) {
        String separator = properties.getProperty(SEPARATOR_FILTER_PROPERTY, ",");
        String resolved = properties.getProperty(property);
        if (resolved == null) {
            return List.of();
        }
        return Arrays.asList(resolved.split(separator));
    }

    private List<Pattern> convert(List<String> list) {
        return list.stream().map(Pattern::compile).collect(Collectors.toCollection(LinkedList::new));
    }

    private boolean matches(List<Pattern> patterns, String value) {
        return patterns.stream().noneMatch(matcher -> matcher.matcher(value).matches());
    }
}

