/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectQueueBrowser
implements Enumeration<Message>,
QueueBrowser {
    private JMSService jmsservice;
    private DirectSession ds;
    private long connectionId;
    private long sessionId;
    private long consumerId = 0L;
    private JMSPacket[] browserMessages;
    private int size;
    private int cursor;
    private Queue destination = null;
    private String msgSelector;
    private boolean isClosed = false;
    protected int _logLevel;
    protected boolean _logFINE = false;
    private static final String _className = "com.sun.messaging.jms.ra.DirectQueueBrowser";
    private static final String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final String _lgrNameJMSQueueBrowser = "jakarta.jms.QueueBrowser.mqjmsra";
    private static final Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final Logger _loggerJQB = Logger.getLogger("jakarta.jms.QueueBrowser.mqjmsra");
    private static final String _lgrMIDPrefix = "MQJMSRA_DQB";
    private static final String _lgrMID_INF = "MQJMSRA_DQB1101: ";
    private static final String _lgrMID_WRN = "MQJMSRA_DQB2001: ";
    private static final String _lgrMID_EXC = "MQJMSRA_DQB4001: ";

    public DirectQueueBrowser() {
    }

    public DirectQueueBrowser(DirectSession ds, JMSService jmsservice, long consumerId, Queue destination, Destination jmsservice_dest, String selector) {
        Object[] params = new Object[]{ds, jmsservice, consumerId, destination, jmsservice_dest, selector};
        _loggerOC.entering(_className, "constructor()", params);
        this.ds = ds;
        this.jmsservice = jmsservice;
        this.consumerId = consumerId;
        this.destination = destination;
        this.msgSelector = "".equals(selector) ? null : selector;
        this.connectionId = ds.getConnectionId();
        this.sessionId = ds.getSessionId();
        Level _level = _loggerJQB.getLevel();
        if (_level != null) {
            this._logLevel = _level.intValue();
            if (this._logLevel <= Level.FINE.intValue()) {
                this._logFINE = true;
            }
        }
    }

    public synchronized void close() throws JMSException {
        _loggerJQB.fine("MQJMSRA_DQB1101: consumerId=" + this.consumerId + ":close()");
        if (this.isClosed) {
            return;
        }
        this.ds.removeBrowser(this);
        this._close();
    }

    public Enumeration getEnumeration() throws JMSException {
        if (this._logFINE) {
            _loggerJQB.fine("MQJMSRA_DQB1101: consumerId=" + this.consumerId + ":getEnumeration()");
        }
        this._checkIfClosed("getEnumeration()");
        this.browserMessages = null;
        this.size = 0;
        this.cursor = 0;
        try {
            this.browserMessages = this.jmsservice.browseMessages(this.connectionId, this.sessionId, this.consumerId);
            if (this.browserMessages != null) {
                this.size = this.browserMessages.length;
            }
            return this;
        }
        catch (JMSServiceException jse) {
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            String exerrmsg = "browseMessages on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and sessionId:" + this.sessionId + " due to " + jse.getMessage();
            Throwable jmse = status == JMSServiceReply.Status.FORBIDDEN ? new JMSSecurityException(exerrmsg) : new JMSException(exerrmsg);
            jmse.initCause((Throwable)jse);
            throw jmse;
        }
    }

    public String getMessageSelector() throws JMSException {
        this._checkIfClosed("getMessageSelector()");
        return this.msgSelector;
    }

    public Queue getQueue() throws JMSException {
        this._checkIfClosed("getQueue()");
        return this.destination;
    }

    @Override
    public boolean hasMoreElements() {
        return this.cursor < this.size;
    }

    @Override
    public Message nextElement() {
        Message msg = null;
        if (this.browserMessages != null) {
            try {
                msg = DirectPacket.constructMessage(this.browserMessages[this.cursor++].getPacket(), this.consumerId, this.ds, this.jmsservice, true);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return msg;
    }

    public long getConsumerId() {
        return this.consumerId;
    }

    protected synchronized void _close() throws JMSException {
        if (this.isClosed) {
            return;
        }
        this.browserMessages = null;
        this.size = 0;
        this.cursor = 0;
        try {
            this.jmsservice.deleteBrowser(this.connectionId, this.sessionId, this.consumerId);
        }
        catch (JMSServiceException jmsse) {
            _loggerJQB.warning("MQJMSRA_DQB2001: consumerId=" + this.consumerId + ":close():JMSService.deleteBrowser():JMSServiceException=" + jmsse.getMessage());
        }
        this.isClosed = true;
    }

    private void _checkIfClosed(String methodname) throws JMSException {
        if (this.isClosed) {
            String closedmsg = _lgrMID_EXC + methodname + "QueueBrowser is closed:Id=" + this.consumerId;
            _loggerJQB.warning(closedmsg);
            throw new IllegalStateException(closedmsg);
        }
    }
}

