/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.single;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.single.ManifestProxy;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyModuleDefinition
implements ModuleDefinition {
    private final ClassLoader classLoader;
    private final List<ManifestProxy.SeparatorMappings> mappings;

    public ProxyModuleDefinition(ClassLoader classLoader) throws IOException {
        this(classLoader, null);
    }

    public ProxyModuleDefinition(ClassLoader classLoader, List<ManifestProxy.SeparatorMappings> mappings) throws IOException {
        this.classLoader = classLoader;
        this.mappings = mappings;
    }

    private static byte[] readFully(URL url) throws IOException {
        try (FilterInputStream dis = null;){
            URLConnection con = url.openConnection();
            int len = con.getContentLength();
            InputStream in = con.getInputStream();
            dis = new DataInputStream(in);
            byte[] bytes = new byte[len];
            ((DataInputStream)dis).readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    @Override
    public String getName() {
        return "Static Module";
    }

    @Override
    public String[] getPublicInterfaces() {
        return new String[0];
    }

    @Override
    public ModuleDependency[] getDependencies() {
        return new ModuleDependency[0];
    }

    @Override
    public URI[] getLocations() {
        ArrayList<URI> uris;
        block5: {
            String[] paths;
            block4: {
                uris = new ArrayList<URI>();
                if (!(this.classLoader instanceof URLClassLoader)) break block4;
                URLClassLoader urlCL = (URLClassLoader)this.classLoader;
                for (URL url : urlCL.getURLs()) {
                    try {
                        uris.add(url.toURI());
                    }
                    catch (URISyntaxException e) {
                        Logger.getAnonymousLogger().log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                break block5;
            }
            String cp = System.getProperty("java.class.path");
            if (!ProxyModuleDefinition.ok(cp) || !ProxyModuleDefinition.ok(paths = cp.split(System.getProperty("path.separator")))) break block5;
            for (int i = 0; i < paths.length; ++i) {
                uris.add(new File(paths[i]).toURI());
            }
        }
        return uris.toArray(new URI[uris.size()]);
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getImportPolicyClassName() {
        return null;
    }

    @Override
    public String getLifecyclePolicyClassName() {
        return null;
    }

    @Override
    public Manifest getManifest() {
        return this.generate(new ModuleMetadata());
    }

    @Override
    public ModuleMetadata getMetadata() {
        ModuleMetadata metadata = new ModuleMetadata();
        this.generate(metadata);
        return metadata;
    }

    protected Manifest generate(ModuleMetadata metadata) {
        try {
            ManifestProxy manifest = new ManifestProxy(this.classLoader, this.mappings);
            return manifest;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static boolean ok(String[] ss) {
        return ss != null && ss.length > 0;
    }
}

