/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.contexts.activators;

import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Vetoed;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import org.jboss.weld.environment.se.WeldSEBeanRegistrant;
import org.jboss.weld.environment.se.contexts.ThreadContext;
import org.jboss.weld.environment.se.contexts.activators.ActivateThreadScope;

@Vetoed
@Interceptor
@ActivateThreadScope
@Priority(value=2100)
public class ActivateThreadScopeInterceptor {
    private final ThreadContext threadContext;

    @Inject
    public ActivateThreadScopeInterceptor(WeldSEBeanRegistrant registrant) {
        this.threadContext = registrant.getThreadContext();
    }

    @AroundInvoke
    Object intercept(InvocationContext invocationContext) throws Exception {
        if (!this.threadContext.isActive()) {
            try {
                this.threadContext.activate();
                Object object = invocationContext.proceed();
                return object;
            }
            finally {
                this.threadContext.invalidate();
                this.threadContext.deactivate();
            }
        }
        return invocationContext.proceed();
    }
}

