/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.factory;

import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.glassfish.ejb.security.application.EjbSecurityProbeProvider;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public final class EJBSecurityManagerFactory
extends SecurityManagerFactory {
    private static final Logger LOG = LogDomains.getLogger(EJBSecurityManagerFactory.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    @Inject
    InvocationManager invocationManager;
    @Inject
    AppServerAuditManager auditManager;
    private final EjbSecurityProbeProvider probeProvider = new EjbSecurityProbeProvider();
    private final Map<String, ArrayList<String>> CONTEXT_IDS = new HashMap<String, ArrayList<String>>();
    private final Map<String, Map<String, EJBSecurityManager>> SECURITY_MANAGERS = new HashMap<String, Map<String, EJBSecurityManager>>();

    public <T> EJBSecurityManager getManager(String ctxId, String name, boolean remove) {
        return (EJBSecurityManager)this.getManager(this.SECURITY_MANAGERS, ctxId, name, remove);
    }

    public <T> ArrayList<EJBSecurityManager> getManagers(String ctxId, boolean remove) {
        return this.getManagers(this.SECURITY_MANAGERS, ctxId, remove);
    }

    public <T> ArrayList<EJBSecurityManager> getManagersForApp(String appName, boolean remove) {
        return this.getManagersForApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, appName, remove);
    }

    public <T> String[] getContextsForApp(String appName, boolean remove) {
        return this.getContextsForApp(this.CONTEXT_IDS, appName, remove);
    }

    public <T> void addManagerToApp(String ctxId, String name, String appName, EJBSecurityManager manager) {
        this.addManagerToApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, ctxId, name, appName, manager);
    }

    public EJBSecurityManager createManager(EjbDescriptor ejbDescriptor, boolean register) {
        String contextId = EJBSecurityManager.getContextID(ejbDescriptor);
        String ejbName = ejbDescriptor.getName();
        EJBSecurityManager manager = null;
        if (register) {
            manager = this.getManager(contextId, ejbName, false);
        }
        if (manager == null || !register) {
            try {
                this.probeProvider.securityManagerCreationStartedEvent(ejbName);
                manager = new EJBSecurityManager(ejbDescriptor, this.invocationManager, this);
                this.probeProvider.securityManagerCreationEndedEvent(ejbName);
                if (register) {
                    String applicationName = ejbDescriptor.getApplication().getRegistrationName();
                    this.addManagerToApp(contextId, ejbName, applicationName, manager);
                    this.probeProvider.securityManagerCreationEvent(ejbName);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "[EJB-Security] FATAL Exception. Unable to create EJBSecurityManager: " + ex.getMessage());
                throw new RuntimeException(ex);
            }
        }
        return manager;
    }

    public AppServerAuditManager getAuditManager() {
        return this.auditManager;
    }
}

