/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.deployment.annotation.handlers;

import com.sun.enterprise.deployment.JMSConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.deployment.annotation.handlers.ResourceAnnotationControl;
import jakarta.jms.JMSConnectionFactoryDefinition;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.Set;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=JMSConnectionFactoryDefinition.class)
public class JMSConnectionFactoryDefinitionHandler
extends AbstractResourceHandler {
    private static final ResourceAnnotationControl CTRL = new ResourceAnnotationControl(JMSConnectionFactoryDefinition.class);

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        JMSConnectionFactoryDefinition jmsConnectionFactoryDefnAn = (JMSConnectionFactoryDefinition)ainfo.getAnnotation();
        return this.processAnnotation(jmsConnectionFactoryDefnAn, ainfo, rcContexts);
    }

    protected HandlerProcessingResult processAnnotation(JMSConnectionFactoryDefinition jmsConnectionFactoryDefnAn, AnnotationInfo aiInfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Class annotatedClass = (Class)aiInfo.getAnnotatedElement();
        Annotation[] annotations = annotatedClass.getAnnotations();
        boolean warClass = this.isAWebComponentClass(annotations);
        boolean ejbClass = this.isAEjbComponentClass(annotations);
        for (ResourceContainerContext context : rcContexts) {
            JMSConnectionFactoryDefinitionDescriptor desc;
            if (!CTRL.canProcessAnnotation(annotatedClass, ejbClass, warClass, context)) {
                return this.getDefaultProcessedResult();
            }
            Set jmscfdDescs = context.getResourceDescriptors(JavaEEResourceType.JMSCFDD);
            if (this.isDefinitionAlreadyPresent(jmscfdDescs, desc = this.createDescriptor(jmsConnectionFactoryDefnAn))) {
                this.merge(jmscfdDescs, jmsConnectionFactoryDefnAn);
                for (ResourceDescriptor jmscfdDesc : jmscfdDescs) {
                    if (!(jmscfdDesc instanceof JMSConnectionFactoryDefinitionDescriptor)) continue;
                    this.setDefaultTransactionSupport((JMSConnectionFactoryDefinitionDescriptor)jmscfdDesc);
                }
                continue;
            }
            this.setDefaultTransactionSupport(desc);
            context.addResourceDescriptor((ResourceDescriptor)desc);
        }
        return this.getDefaultProcessedResult();
    }

    private void setDefaultTransactionSupport(JMSConnectionFactoryDefinitionDescriptor desc) {
        Properties props = desc.getProperties();
        if (props.get("org.glassfish.connector-connection-pool.transaction-support") == null) {
            props.put("org.glassfish.connector-connection-pool.transaction-support", "XATransaction");
        }
    }

    private boolean isDefinitionAlreadyPresent(Set<ResourceDescriptor> jmscfdDescs, JMSConnectionFactoryDefinitionDescriptor desc) {
        for (ResourceDescriptor descriptor : jmscfdDescs) {
            if (!descriptor.equals(desc)) continue;
            return true;
        }
        return false;
    }

    private void merge(Set<ResourceDescriptor> jmscfdDescs, JMSConnectionFactoryDefinition defn) {
        for (ResourceDescriptor descriptor : jmscfdDescs) {
            JMSConnectionFactoryDefinitionDescriptor desc;
            if (!(descriptor instanceof JMSConnectionFactoryDefinitionDescriptor) || !(desc = (JMSConnectionFactoryDefinitionDescriptor)descriptor).getName().equals(defn.name())) continue;
            if (desc.getInterfaceName() == null) {
                desc.setInterfaceName(defn.interfaceName());
            }
            if (desc.getClassName() == null && this.isValid(defn.className())) {
                desc.setClassName(defn.className());
            }
            if (desc.getDescription() == null && this.isValid(defn.description())) {
                desc.setDescription(defn.description());
            }
            if (desc.getResourceAdapter() == null && this.isValid(defn.resourceAdapter())) {
                desc.setResourceAdapter(defn.resourceAdapter());
            }
            if (desc.getUser() == null && this.isValid(defn.user())) {
                desc.setUser(defn.user());
            }
            if (desc.getPassword() == null && defn.password() != null) {
                desc.setPassword(defn.password());
            }
            if (desc.getClientId() == null && this.isValid(defn.clientId())) {
                desc.setClientId(defn.clientId());
            }
            if (!desc.isTransactionSet()) {
                desc.setTransactional(defn.transactional());
            }
            if (desc.getMaxPoolSize() < 0 && defn.maxPoolSize() >= 0) {
                desc.setMaxPoolSize(defn.maxPoolSize());
            }
            if (desc.getMinPoolSize() < 0 && defn.minPoolSize() >= 0) {
                desc.setMinPoolSize(defn.minPoolSize());
            }
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length <= 0) break;
            for (String property : defnProperties) {
                int index = property.indexOf(61);
                if (index <= 0 || index >= property.length() - 1) continue;
                String name = property.substring(0, index).trim();
                String value = property.substring(index + 1).trim();
                if (properties.get(name) != null) continue;
                properties.put(name, value);
            }
        }
    }

    private JMSConnectionFactoryDefinitionDescriptor createDescriptor(JMSConnectionFactoryDefinition defn) {
        JMSConnectionFactoryDefinitionDescriptor desc = new JMSConnectionFactoryDefinitionDescriptor();
        desc.setMetadataSource(MetadataSource.ANNOTATION);
        desc.setName(defn.name());
        desc.setInterfaceName(defn.interfaceName());
        if (this.isValid(defn.className())) {
            desc.setClassName(defn.className());
        }
        if (this.isValid(defn.description())) {
            desc.setDescription(defn.description());
        }
        if (this.isValid(defn.resourceAdapter())) {
            desc.setResourceAdapter(defn.resourceAdapter());
        }
        if (this.isValid(defn.user())) {
            desc.setUser(defn.user());
        }
        if (defn.password() != null) {
            desc.setPassword(defn.password());
        }
        if (this.isValid(defn.clientId())) {
            desc.setClientId(defn.clientId());
        }
        desc.setTransactional(defn.transactional());
        if (defn.maxPoolSize() >= 0) {
            desc.setMaxPoolSize(defn.maxPoolSize());
        }
        if (defn.minPoolSize() >= 0) {
            desc.setMinPoolSize(defn.minPoolSize());
        }
        if (defn.properties() != null) {
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length > 0) {
                for (String property : defnProperties) {
                    int index = property.indexOf("=");
                    if (index <= 0 || index >= property.length() - 1) continue;
                    String name = property.substring(0, index).trim();
                    String value = property.substring(index + 1).trim();
                    properties.put(name, value);
                }
            }
        }
        return desc;
    }

    private boolean isValid(String s) {
        return s != null && !s.isEmpty();
    }
}

