/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.QueueBrowserImpl;
import com.sun.messaging.jmq.jmsclient.ReceiveQueue;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class BrowserConsumer
extends Consumer
implements Enumeration,
Traceable {
    protected SessionImpl session = null;
    protected QueueBrowserImpl browser = null;
    protected ReceiveQueue receiveQueue = null;
    private long browseTimeout = 60000L;
    private int browseChunkLimit = 1000;
    private SysMessageID[] messageIDs = null;
    private int cursor = 0;
    private int cursorEnd = 0;
    private int waitCounter = 0;

    BrowserConsumer(QueueBrowserImpl browser, Destination dest) throws JMSException {
        this(browser, dest, null);
    }

    BrowserConsumer(QueueBrowserImpl browser, Destination dest, String messageSelector) throws JMSException {
        super(browser.getSession().getConnection(), dest, messageSelector, false);
        this.browser = browser;
        this.session = browser.getSession();
        try {
            this.browseTimeout = Long.parseLong(this.session.getConnection().getProperty("imqQueueBrowserRetrieveTimeout"));
            this.browseChunkLimit = Integer.parseInt(this.session.getConnection().getProperty("imqQueueBrowserMaxMessagesPerRetrieve"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.init();
    }

    private void init() throws JMSException {
        this.receiveQueue = new ReceiveQueue();
        this.messageIDs = this.session.getMessageIdSet(this);
        this.cursorEnd = this.messageIDs.length - 1;
        this.cursor = 0;
        this.addInterest();
        this.waitCounter = 0;
        this.moreMessage();
    }

    private void addInterest() {
        this.connection.addLocalInterest(this);
    }

    private void removeInterest() {
        this.connection.removeLocalInterest(this);
        this.session.removeBrowserConsumer(this);
        FlowControl fc = this.connection.getReadChannel().flowControl;
        fc.removeConsumerFlowControl(this);
    }

    @Override
    protected Long getReadQueueId() {
        return this.session.getSessionId();
    }

    @Override
    protected void onMessage(MessageImpl message) throws JMSException {
        if (this.receiveQueue.getIsClosed()) {
            return;
        }
        this.receiveQueue.enqueueNotify(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receive(long timeout) throws JMSException {
        MessageImpl message = null;
        try {
            message = (MessageImpl)this.receiveQueue.dequeueWait(timeout);
            if (message != null) {
                message.setIsBrowserMsg(true);
            }
        }
        finally {
            this.receiveQueue.setReceiveInProcess(false);
        }
        return message;
    }

    private void moreMessage() throws JMSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(36);
        DataOutputStream dos = new DataOutputStream(bos);
        boolean moreComming = false;
        SysMessageID messageID = null;
        while (!moreComming && this.cursor <= this.cursorEnd) {
            int count;
            for (count = 0; this.cursor <= this.cursorEnd && count < this.browseChunkLimit; ++count) {
                messageID = this.messageIDs[this.cursor];
                try {
                    messageID.writeID(dos);
                }
                catch (IOException e) {
                    ExceptionHandler.handleException((Exception)e, "C4038");
                }
                ++this.cursor;
            }
            if (count <= 0) continue;
            try {
                dos.flush();
                bos.flush();
            }
            catch (IOException e) {
                ExceptionHandler.handleException((Exception)e, "C4038");
            }
            moreComming = this.session.requestMessages(bos, this);
            bos.reset();
        }
        if (moreComming) {
            ++this.waitCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMoreElements() {
        if (this.receiveQueue.getIsClosed()) {
            String errorString = AdministeredObject.cr.getKString("C4046");
            throw new NoSuchElementException(errorString);
        }
        BrowserConsumer browserConsumer = this;
        synchronized (browserConsumer) {
            return this.waitCounter != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object nextElement() {
        Message message = null;
        BrowserConsumer browserConsumer = this;
        synchronized (browserConsumer) {
            if (!this.hasMoreElements()) {
                String errorString = AdministeredObject.cr.getKString("C4045");
                throw new NoSuchElementException(errorString);
            }
            try {
                message = this.receive(this.browseTimeout);
                if (message != null && this.isLast((MessageImpl)message)) {
                    --this.waitCounter;
                    this.moreMessage();
                }
            }
            catch (JMSException e) {
                this.close();
                throw new NoSuchElementException(e.getMessage());
            }
        }
        if (message == null) {
            String errorString;
            if (this.receiveQueue.getIsClosed()) {
                errorString = AdministeredObject.cr.getKString("C4046");
                throw new NoSuchElementException(errorString);
            }
            this.close();
            errorString = AdministeredObject.cr.getKString("C4044");
            throw new NoSuchElementException(errorString);
        }
        return message;
    }

    private boolean isLast(MessageImpl message) {
        return message.getPacket().getIsLast();
    }

    protected QueueBrowserImpl getBrowser() {
        return this.browser;
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    protected void close() {
        if (this.receiveQueue.getIsClosed()) {
            return;
        }
        this.receiveQueue.close();
        this.removeInterest();
        if (this.debug) {
            Debug.println("browser consumer closed ...");
            Debug.println(this);
        }
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ BrowserConsumer dump ------");
        ps.println("Interest ID: " + this.getInterestId());
        ps.println("destination: " + String.valueOf(this.getDestination()));
        ps.println("selector: " + this.messageSelector);
        ps.println("waitCounter: " + this.waitCounter);
        if (this.receiveQueue != null) {
            this.receiveQueue.dump(ps);
        } else {
            ps.println("receiveQueue is null.");
        }
    }
}

