/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class JMQByteBufferInputStream
extends InputStream {
    protected ByteBuffer buf;

    public JMQByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public synchronized int read() {
        this.ensureOpen();
        try {
            return this.buf.get() & 0xFF;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        this.ensureOpen();
        if (this.available() == 0) {
            return -1;
        }
        if (len > this.available()) {
            len = this.available();
        }
        try {
            this.buf.get(b, off, len);
        }
        catch (Exception e) {
            System.err.println(this.getClass().getName() + ": Got exception when reading " + len + " bytes from buffer " + String.valueOf(this.buf));
            return -2;
        }
        return len;
    }

    @Override
    public synchronized long skip(long n) {
        this.ensureOpen();
        if (n > (long)this.available()) {
            n = this.available();
        }
        this.buf.position((int)((long)this.buf.position() + n));
        return n;
    }

    @Override
    public synchronized int available() {
        this.ensureOpen();
        return this.buf.remaining();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.ensureOpen();
        this.buf.mark();
    }

    @Override
    public synchronized void reset() {
        this.ensureOpen();
        this.buf.rewind();
    }

    @Override
    public synchronized void close() throws IOException {
        this.buf = null;
    }

    private void ensureOpen() {
    }

    public ByteBuffer getByteBuffer() {
        return this.buf;
    }
}

