/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.servlet;

import jakarta.mvc.Controller;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.ws.rs.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.krazo.util.AnnotationUtils;

@HandlesTypes(value={Path.class})
public class KrazoContainerInitializer
implements ServletContainerInitializer {
    public static final String CONTROLLER_CLASSES = KrazoContainerInitializer.class.getName() + ".CONTROLLER_CLASSES";
    private static final Logger LOG = Logger.getLogger(KrazoContainerInitializer.class.getName());

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        LOG.log(Level.INFO, "Eclipse Krazo version {0} started", this.getClass().getPackage().getImplementationVersion());
        LinkedHashSet controllerClasses = new LinkedHashSet();
        for (Class<?> clazz : classes) {
            if (!AnnotationUtils.hasAnnotationOnClassOrMethod(clazz, Path.class) || !AnnotationUtils.hasAnnotationOnClassOrMethod(clazz, Controller.class)) continue;
            controllerClasses.add(clazz);
        }
        servletContext.setAttribute(CONTROLLER_CLASSES, Collections.unmodifiableSet(controllerClasses));
    }
}

