/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq;

import com.sun.messaging.jmq.resources.SharedResources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class Version {
    private static String[] patchTermsList = new String[]{"SP", "UR", "_", "U", "PATCH", "UPDATE"};
    private static HashSet patchTerms = new HashSet();
    private String propname = "/com/sun/messaging/jmq/version.properties";
    private String comm_propname = "/com/sun/messaging/jmq/brand_version.properties";
    private static String imqhome_propname;
    private static final String IMQ_HOME;
    private static final String PATCHIDFILE;
    private Properties props = null;
    private String miniCopyright = "Copyright (c) 2013, 2018 Oracle and/or its affiliates.  All rights reserved.\nCopyright (c) 2018, 2025 Contributors to Eclipse Foundation.";
    private String shortCopyright = "Copyright (c) 2013, 2018 Oracle and/or its affiliates. All rights reserved.\nCopyright (c) 2018, 2025 Contributors to Eclipse Foundation.";
    private String longCopyright = "Copyright (c) 2013, 2018 Oracle and/or its affiliates.  All rights reserved.\nCopyright (c) 2018, 2025 Contributors to Eclipse Foundation.";
    public static final int MINI_COPYRIGHT = 0;
    public static final int SHORT_COPYRIGHT = 1;
    public static final int LONG_COPYRIGHT = 2;
    private static String thisPackage;
    private static SharedResources rb;
    private boolean isJar = false;

    public Version() {
        this(true);
    }

    public Version(boolean isJar) {
        this.isJar = isJar;
        try {
            InputStream is = this.getClass().getResourceAsStream(this.propname);
            if (is == null) {
                System.err.println(rb.getString("S3006"));
            }
            this.props = new Properties();
            this.props.load(is);
            is = this.getClass().getResourceAsStream(this.comm_propname);
            if (is != null) {
                this.props.load(is);
            }
        }
        catch (Exception ex) {
            System.err.println(rb.getString("S3007"));
            ex.printStackTrace();
        }
    }

    public Properties getProps() {
        return this.props;
    }

    public String getProductVersion() {
        return this.props.getProperty("imq.product.version");
    }

    public int getMajorVersion() {
        try {
            return Integer.parseInt(this.props.getProperty("imq.product.major"));
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public int getMinorVersion() {
        try {
            return Integer.parseInt(this.props.getProperty("imq.product.minor"));
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public String getVersionProperty(String name) {
        return this.props.getProperty(name);
    }

    public String getBuildMilestone() {
        String milestone = this.props.getProperty("imq.build.milestone");
        if ("FCS".equals(milestone)) {
            return "";
        }
        return milestone;
    }

    public String getBuildDate() {
        return this.props.getProperty("imq.build.date");
    }

    public String getBuildVersion() {
        return this.props.getProperty("imq.product.version") + " " + this.getBuildMilestone() + " (Build " + this.props.getProperty("imq.build.number") + "-" + this.props.getProperty("imq.build.letter") + ")";
    }

    public String getProductName() {
        if (this.isJar) {
            return this.props.getProperty("imq.product.jarname");
        }
        return this.props.getProperty("imq.product.name");
    }

    public String getReleaseQID() {
        return this.props.getProperty("imq.product.releaseqid");
    }

    public String getAbbreviatedProductName() {
        return this.props.getProperty("imq.product.name.abbrev");
    }

    public String getLowerCaseAbbreviatedProductName() {
        return this.props.getProperty("imq.product.name.abbrev.lowercase");
    }

    public String getShortProductName() {
        return this.props.getProperty("imq.product.name.short");
    }

    public String getProductCopyrightDate() {
        return this.props.getProperty("imq.product.copyright.date");
    }

    public String getProductCompanyName() {
        return this.props.getProperty("imq.product.companyname");
    }

    public String getVersionPackageName() {
        return this.props.getProperty("imq.version.package");
    }

    public String getImplementationVersion() {
        return this.props.getProperty("imq.api.version");
    }

    public String getProtocolVersion() {
        return this.props.getProperty("imq.protocol.version");
    }

    public String getTargetJMSVersion() {
        return this.props.getProperty("imq.jms.api.version");
    }

    public boolean isCommercialProduct() {
        String val = this.props.getProperty("imq.product.brand");
        return Boolean.parseBoolean(val);
    }

    public boolean isProductValid() {
        if (!this.isCommercialProduct()) {
            return true;
        }
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        int major_comm = -1;
        int minor_comm = -1;
        try {
            major_comm = Integer.parseInt(this.props.getProperty("imq.product.brand.major"));
            minor_comm = Integer.parseInt(this.props.getProperty("imq.product.brand.minor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return major_comm == major && minor_comm == minor;
    }

    public String getUserAgent() {
        return this.getShortProductName() + "/" + this.getProductVersion() + " (JMS; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ")";
    }

    public String toString() {
        return this.getBanner(false);
    }

    public String getHeader() {
        return this.getHeader(2);
    }

    public String getHeader(int copyrightType) {
        return rb.getString("S1000") + this.getProductName() + " " + this.getReleaseQID() + SharedResources.NL + this.getProductCompanyName() + SharedResources.NL + rb.getString("S1001") + this.getBuildVersion() + SharedResources.NL + rb.getString("S1002") + this.getBuildDate() + SharedResources.NL + SharedResources.NL + this.getCopyright(copyrightType) + SharedResources.NL + rb.getString("S1000");
    }

    public String getRAVersion() {
        return rb.getString("S1001") + this.getBuildVersion() + " " + rb.getString("S1002") + this.getBuildDate();
    }

    public String getCopyright(int copyrightType) {
        switch (copyrightType) {
            case 0: {
                return this.miniCopyright;
            }
            case 1: {
                return this.shortCopyright;
            }
            case 2: {
                return this.longCopyright;
            }
        }
        return this.shortCopyright;
    }

    public String[] getPatchIds() {
        String propValue;
        File patchFile = new File(PATCHIDFILE);
        if (!patchFile.exists()) {
            return null;
        }
        if (!patchFile.canRead()) {
            return null;
        }
        Properties patchProps = new Properties();
        try (FileInputStream fis = new FileInputStream(PATCHIDFILE);){
            patchProps.load(fis);
        }
        catch (Exception e) {
            return null;
        }
        String propName = this.getMajorVersion() + "." + this.getMinorVersion();
        String[] patchids = new String[1000];
        int num = 0;
        for (int i = 1; i < patchids.length && (propValue = patchProps.getProperty(propName + "_" + i)) != null; ++i) {
            patchids[num++] = propValue;
        }
        String[] retids = Arrays.copyOf(patchids, num);
        return retids;
    }

    public String getPatchString() {
        String[] patchids = this.getPatchIds();
        StringBuilder ret = new StringBuilder();
        if (patchids != null && patchids.length >= 1) {
            for (int j = 0; j < patchids.length && patchids[j] != null; ++j) {
                if (ret.toString().equals("")) {
                    ret.append(rb.getString("S1009") + patchids[j] + SharedResources.NL);
                    continue;
                }
                if (patchids[j] == null) continue;
                ret.append(rb.getString("S1010") + patchids[j] + SharedResources.NL);
            }
        }
        return ret.toString();
    }

    public String getJMSAdminSpiVersion() {
        return this.props.getProperty("imq.jmsadmin.spi.version");
    }

    public String getVersion() {
        return this.getVersionPackageName() + rb.getString("S1004") + rb.getString("S1005") + this.getImplementationVersion() + SharedResources.NL + rb.getString("S1006") + this.getProtocolVersion() + SharedResources.NL + rb.getString("S1007") + this.getTargetJMSVersion() + SharedResources.NL + this.getPatchString();
    }

    public String getBanner(boolean alldata) {
        return this.getBanner(alldata, 1);
    }

    public String getBanner(boolean alldata, int copyrightType) {
        if (this.props == null) {
            return rb.getString("S3008") + thisPackage;
        }
        if (alldata) {
            return this.getHeader(copyrightType) + this.getVersion();
        }
        return this.getHeader(copyrightType);
    }

    public static int[] getIntVersion(String str) {
        int[] returnver = new int[4];
        String newstr = Version.stripTrailingLetters(str.toUpperCase().trim());
        StringTokenizer tkn = new StringTokenizer(newstr, ".");
        String token = "";
        for (int i = 0; tkn.hasMoreTokens() && i < 4; ++i) {
            token = tkn.nextToken();
            try {
                returnver[i] = Integer.parseInt(token);
                continue;
            }
            catch (NumberFormatException e) {
                int pos = 0;
                if (Character.isDigit(token.charAt(pos))) {
                    String value = Version.getNumber(token);
                    try {
                        returnver[i] = Integer.parseInt(value);
                        ++i;
                    }
                    catch (NumberFormatException ex) {
                        System.out.println("Can't parse " + token + ": " + String.valueOf(e));
                    }
                    token = token.substring(pos += value.length());
                }
                for (pos = 0; pos < token.length() && !Character.isDigit(token.charAt(pos)); ++pos) {
                }
                String patchString = token.substring(0, pos).trim();
                if (!patchTerms.contains(patchString)) break;
                String patchNumber = token.substring(pos);
                patchNumber = Version.getNumber(patchNumber);
                try {
                    returnver[3] = Integer.parseInt(patchNumber);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
        }
        return returnver;
    }

    static String getNumber(String s) {
        int j;
        for (j = 0; j < s.length() && Character.isDigit(s.charAt(j)); ++j) {
        }
        return s.substring(0, j);
    }

    private static String stripTrailingLetters(String s) {
        int n = s.length() - 1;
        while (!Character.isDigit(s.charAt(n))) {
            --n;
        }
        if (n == s.length() - 1) {
            return s;
        }
        return s.substring(0, n + 1);
    }

    public static int compareVersions(String stra, String strb) {
        return Version.compareVersions(stra, strb, true);
    }

    public static int compareVersions(String verA, String verB, boolean ignoreServicePack) {
        int[] aver = Version.getIntVersion(verA);
        int[] bver = Version.getIntVersion(verB);
        if (ignoreServicePack) {
            aver[3] = 0;
            bver[3] = 0;
        }
        return Version.compareVersions(aver, bver);
    }

    private static int compareVersions(int[] s1, int[] s2) {
        int comparelen = s1.length > s2.length ? s1.length : s2.length;
        for (int indx = 0; indx < comparelen; ++indx) {
            int val2;
            int val1 = s1.length > indx ? s1[indx] : 0;
            int n = val2 = s2.length > indx ? s2[indx] : 0;
            if (val1 > val2) {
                return 1;
            }
            if (val1 >= val2) continue;
            return -1;
        }
        return 0;
    }

    public static String toVersionString(int[] ver) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < ver.length; ++i) {
            s.append(ver[i]);
            if (i + 1 >= ver.length) continue;
            s.append('.');
        }
        return s.toString();
    }

    static {
        for (int i = 0; i < patchTermsList.length; ++i) {
            try {
                patchTerms.add(patchTermsList[i]);
                continue;
            }
            catch (Exception e) {
                System.out.println("Version: Could not add patch term " + patchTermsList[i] + ": " + String.valueOf(e));
            }
        }
        imqhome_propname = "imq.home";
        IMQ_HOME = System.getProperty(imqhome_propname, ".");
        PATCHIDFILE = IMQ_HOME + File.separator + "patches" + File.separator + "VERSION";
        thisPackage = "com.sun.messaging";
        rb = SharedResources.getResources();
    }
}

