/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import com.sun.enterprise.deployment.ManagedExecutorDefinitionDescriptor;
import com.sun.enterprise.deployment.annotation.handlers.ContextualResourceDefinition;
import jakarta.inject.Inject;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.ConcurrencyDeployer;
import org.glassfish.concurrent.runtime.deployer.ConcurrencyManagedExecutorServiceConfig;
import org.glassfish.concurrent.runtime.deployer.cfg.ManagedExecutorServiceCfg;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.ManagedExecutorServiceImpl;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.jvnet.hk2.annotations.Service;

@Service
@ResourceDeployerInfo(value=ManagedExecutorDefinitionDescriptor.class)
public class ConcurrencyManagedExecutorDeployer
extends ConcurrencyDeployer<ManagedExecutorDefinitionDescriptor> {
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ResourceNamingService namingService;
    @Inject
    private ConcurrentRuntime runtime;

    public boolean handles(Object resource) {
        return resource instanceof ManagedExecutorDefinitionDescriptor;
    }

    public void deployResource(ManagedExecutorDefinitionDescriptor resource) throws Exception {
        String applicationName = this.invocationManager.getCurrentInvocation().getAppName();
        String moduleName = this.invocationManager.getCurrentInvocation().getModuleName();
        this.deployResource(resource, applicationName, moduleName);
    }

    public void deployResource(ManagedExecutorDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
        ManagedExecutorDefinitionDescriptor descriptor = resource;
        ManagedExecutorServiceImpl service = this.createExecutorService(applicationName, moduleName, descriptor);
        ResourceInfo resourceInfo = new ResourceInfo(this.toResourceName(descriptor), applicationName, moduleName);
        this.namingService.publishObject((GenericResourceInfo)resourceInfo, (Object)service, true);
    }

    public void undeployResource(ManagedExecutorDefinitionDescriptor resource) throws Exception {
        ManagedExecutorDefinitionDescriptor descriptor = resource;
        String applicationName = this.invocationManager.getCurrentInvocation().getAppName();
        String moduleName = this.invocationManager.getCurrentInvocation().getModuleName();
        SimpleJndiName resourceName = this.toResourceName(descriptor);
        ResourceInfo resourceInfo = new ResourceInfo(resourceName, applicationName, moduleName);
        this.namingService.unpublishObject((GenericResourceInfo)resourceInfo);
        this.runtime.shutdownContextService(resourceName);
    }

    public void undeployResource(ManagedExecutorDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
        ManagedExecutorDefinitionDescriptor descriptor = resource;
        SimpleJndiName resourceName = this.toResourceName(descriptor);
        ResourceInfo resourceInfo = new ResourceInfo(resourceName, applicationName, moduleName);
        this.namingService.unpublishObject((GenericResourceInfo)resourceInfo);
        this.runtime.shutdownContextService(resourceName);
    }

    public void redeployResource(ManagedExecutorDefinitionDescriptor resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    private ManagedExecutorServiceImpl createExecutorService(String applicationName, String moduleName, ManagedExecutorDefinitionDescriptor descriptor) {
        ConcurrencyManagedExecutorServiceConfig config = new ConcurrencyManagedExecutorServiceConfig(descriptor);
        ManagedExecutorServiceCfg mesConfig = new ManagedExecutorServiceCfg(config);
        ContextServiceImpl contextService = this.runtime.findOrCreateContextService((ContextualResourceDefinition)descriptor, applicationName, moduleName);
        return this.runtime.createManagedExecutorService(mesConfig, contextService);
    }
}

