/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.event;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.faces.component.StateHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ValueChangeEvent;
import jakarta.faces.event.ValueChangeListener;

public final class MethodExprValueChangeListener
implements ValueChangeListener,
StateHolder {
    private MethodExpression methodExpression = null;
    private boolean isTransient;

    public MethodExprValueChangeListener() {
    }

    public MethodExprValueChangeListener(MethodExpression newMethodExpression) {
        this.methodExpression = newMethodExpression;
    }

    public void processValueChange(ValueChangeEvent valueChangeEvent) throws AbortProcessingException {
        if (valueChangeEvent == null) {
            throw new NullPointerException();
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = context.getELContext();
            this.methodExpression.invoke(elContext, new Object[]{valueChangeEvent});
        }
        catch (ELException ee) {
            throw new AbortProcessingException(ee.getMessage(), ee.getCause());
        }
    }

    public Object saveState(FacesContext context) {
        return new Object[]{this.methodExpression};
    }

    public void restoreState(FacesContext context, Object state) {
        this.methodExpression = (MethodExpression)((Object[])state)[0];
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    public MethodExpression getMethodExpression() {
        return this.methodExpression;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof MethodExprValueChangeListener)) {
            return false;
        }
        MethodExprValueChangeListener other = (MethodExprValueChangeListener)otherObject;
        MethodExpression otherMe = other.getMethodExpression();
        return this.methodExpression.equals((Object)otherMe);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash;
        if (this.methodExpression != null) {
            hash += this.methodExpression.hashCode();
        }
        hash = 47 * hash;
        if (this.isTransient) {
            ++hash;
        }
        return hash;
    }
}

