/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.spi.ManagedConnectionImpl;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ManagedConnectionMetaData;
import jakarta.resource.spi.security.PasswordCredential;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ManagedConnectionMetaDataImpl
implements ManagedConnectionMetaData {
    private static Logger _logger = LogDomains.getLogger(ManagedConnectionMetaDataImpl.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private DatabaseMetaData databaseMetaData;
    private ManagedConnectionImpl managedConnection;

    public ManagedConnectionMetaDataImpl(ManagedConnectionImpl managedConnection) throws ResourceException {
        try {
            this.managedConnection = managedConnection;
            this.databaseMetaData = managedConnection.getActualConnection().getMetaData();
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_md", sqle);
            throw new ResourceException(sqle.getMessage(), (Throwable)sqle);
        }
    }

    public String getEISProductName() throws ResourceException {
        try {
            return this.databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_eis_prodname", sqle);
            throw new ResourceException(sqle.getMessage(), (Throwable)sqle);
        }
    }

    public String getEISProductVersion() throws ResourceException {
        try {
            return this.databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_eis_prodvers", sqle);
            throw new ResourceException(sqle.getMessage(), sqle.getMessage());
        }
    }

    public int getMaxConnections() throws ResourceException {
        try {
            return this.databaseMetaData.getMaxConnections();
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_eis_maxconn");
            throw new ResourceException(sqle.getMessage(), (Throwable)sqle);
        }
    }

    public String getUserName() throws ResourceException {
        PasswordCredential passwordCredential = this.managedConnection.getPasswordCredential();
        if (passwordCredential != null) {
            return passwordCredential.getUserName();
        }
        return this.managedConnection.getManagedConnectionFactory().getUser();
    }
}

