/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceRef;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.weld.services.InjectionServicesImpl;
import org.glassfish.weld.services.WsInjectionHandler;

public final class WsInjectionHandlerImpl
implements WsInjectionHandler {
    @Override
    public boolean handles(AnnotatedField<?> annotatedField) {
        try {
            return annotatedField.isAnnotationPresent(WebServiceRef.class);
        }
        catch (NoClassDefFoundError error) {
            return false;
        }
    }

    @Override
    public void validateWebServiceRef(AnnotatedField<?> annotatedField) {
        WebServiceRef webServiceRef = (WebServiceRef)annotatedField.getAnnotation(WebServiceRef.class);
        if (webServiceRef != null) {
            if (Service.class.isAssignableFrom(annotatedField.getJavaMember().getType())) {
                return;
            }
            if (!annotatedField.getJavaMember().getType().isInterface()) {
                throw new DefinitionException("The type of the injection point " + annotatedField.getJavaMember().getName() + " is " + annotatedField.getJavaMember().getType().getName() + ".  This type is invalid for a field annotated with @WebSreviceRef");
            }
            Class serviceClass = webServiceRef.value();
            if (serviceClass != null && !Service.class.isAssignableFrom(serviceClass)) {
                throw new DefinitionException("The type of the injection point " + annotatedField.getJavaMember().getName() + " is an interface: " + annotatedField.getJavaMember().getType().getName() + ".  The @WebSreviceRef value of " + serviceClass + " is not assignable from " + Service.class.getName());
            }
        }
    }

    @Override
    public SimpleJndiName getJndiName(AnnotatedField<?> annotatedField) {
        WebServiceRef webServiceRef = (WebServiceRef)annotatedField.getAnnotation(WebServiceRef.class);
        return InjectionServicesImpl.getJndiName(webServiceRef.lookup(), webServiceRef.mappedName(), webServiceRef.name());
    }
}

