/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.full.deployment;

import com.sun.enterprise.deployment.deploy.shared.Util;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.EarArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.javaee.full.deployment.EarSniffer;
import org.jvnet.hk2.annotations.Service;

@Service(name="ear")
@Singleton
public class EarDetector
implements ArchiveDetector {
    public static final String EAR_DETECTOR_RANK_PROP = "glassfish.ear.detector.rank";
    public static final int DEFAULT_EAR_DETECTOR_RANK = 100;
    public static final String ARCHIVE_TYPE = "ear";
    private final Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private static final String APPLICATION_XML = "META-INF/application.xml";
    private static final String SUN_APPLICATION_XML = "META-INF/sun-application.xml";
    private static final String GF_APPLICATION_XML = "META-INF/glassfish-application.xml";
    private static final String EAR_EXTENSION = ".ear";
    private static final String EXPANDED_WAR_SUFFIX = "_war";
    private static final String EXPANDED_RAR_SUFFIX = "_rar";
    private static final String EXPANDED_JAR_SUFFIX = "_jar";
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private EarSniffer sniffer;
    private ArchiveHandler archiveHandler;

    public int rank() {
        return Integer.getInteger(EAR_DETECTOR_RANK_PROP, 100);
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        boolean isEar = false;
        try {
            if (Util.getURIName((URI)archive.getURI()).endsWith(EAR_EXTENSION)) {
                return true;
            }
            boolean bl = isEar = archive.exists(APPLICATION_XML) || archive.exists(SUN_APPLICATION_XML) || archive.exists(GF_APPLICATION_XML);
            if (!isEar) {
                isEar = EarDetector.isEARFromIntrospecting(archive);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isEar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveHandler getArchiveHandler() {
        EarDetector earDetector = this;
        synchronized (earDetector) {
            if (this.archiveHandler == null) {
                try {
                    this.sniffer.setup(null, this.logger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.archiveHandler = (ArchiveHandler)this.serviceLocator.getService(ArchiveHandler.class, ARCHIVE_TYPE, new Annotation[0]);
            }
            return this.archiveHandler;
        }
    }

    public ArchiveType getArchiveType() {
        return EarArchiveType.EAR_ARCHIVE;
    }

    private static boolean isEARFromIntrospecting(ReadableArchive archive) throws IOException {
        for (String entryName : archive.getDirectories()) {
            if (!entryName.endsWith(EXPANDED_WAR_SUFFIX) && !entryName.endsWith(EXPANDED_RAR_SUFFIX) && !entryName.endsWith(EXPANDED_JAR_SUFFIX)) continue;
            return true;
        }
        return false;
    }
}

