/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.generator.io;

import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriter;
import com.sun.jdo.spi.persistence.utility.generator.io.FormattedWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class IOJavaClassWriter
implements JavaClassWriter {
    private static final String FIELD = "FIELD";
    private static final String INITIALIZER = "INITIALIZER";
    private static final String CONSTRUCTOR = "CONSTRUCTOR";
    private static final String METHOD = "METHOD";
    private static final String INNER_CLASS = "INNER_CLASS";
    private static final String MIXED = "MIXED";
    private static final String COMMA_SEPARATOR = ", ";
    private boolean _maintainCategories;
    private String _superclass;
    private String _classDeclarationBlock;
    private List _interfaces = new ArrayList();
    private Map _members = new HashMap();

    public IOJavaClassWriter() {
        this(true);
    }

    public IOJavaClassWriter(boolean maintainCategories) {
        this._maintainCategories = maintainCategories;
    }

    @Override
    public void setClassDeclaration(int modifiers, String className, String[] comments) {
        FormattedWriter writerHelper = new FormattedWriter();
        String modifierString = Modifier.toString(modifiers);
        writerHelper.writeComments(comments);
        writerHelper.writeln(modifierString + (modifierString.length() > 0 ? " " : "") + "class " + className);
        this._classDeclarationBlock = writerHelper.toString();
    }

    @Override
    public void setSuperclass(String name) {
        this._superclass = name;
    }

    @Override
    public void addInterface(String name) {
        if (!StringHelper.isEmpty(name)) {
            this._interfaces.add(name);
        }
    }

    @Override
    public void addField(String name, int modifiers, String type, String initialValue, String[] comments) {
        FormattedWriter writerHelper = new FormattedWriter();
        String fieldString = Modifier.toString(modifiers) + " " + type + " " + name;
        writerHelper.writeComments(comments);
        writerHelper.writeln(fieldString + (String)(initialValue != null ? " = " + initialValue : "") + ";");
        this.getMemberList(FIELD).add(writerHelper.toString());
    }

    @Override
    public void addInitializer(boolean isStatic, String[] body, String[] comments) {
        FormattedWriter writerHelper = new FormattedWriter();
        int n = body != null ? body.length : 0;
        writerHelper.writeComments(comments);
        writerHelper.writeln(isStatic ? "static" : "");
        writerHelper.writeln("{");
        for (int i = 0; i < n; ++i) {
            writerHelper.writeln(1, body[i]);
        }
        writerHelper.writeln("}");
        this.getMemberList(INITIALIZER).add(writerHelper.toString());
    }

    @Override
    public void addConstructor(String name, int modifiers, String[] parameterNames, String[] parameterTypes, String[] exceptions, String[] body, String[] comments) {
        this.addMethod(name, modifiers, null, parameterNames, parameterTypes, exceptions, body, comments, this.getMemberList(CONSTRUCTOR));
    }

    @Override
    public void addMethod(String name, int modifiers, String returnType, String[] parameterNames, String[] parameterTypes, String[] exceptions, String[] body, String[] comments) {
        this.addMethod(name, modifiers, returnType, parameterNames, parameterTypes, exceptions, body, comments, this.getMemberList(METHOD));
    }

    @Override
    public void addClass(JavaClassWriter classWriter) {
        if (classWriter != null) {
            this.getMemberList(INNER_CLASS).add(classWriter);
        }
    }

    public String toString() {
        FormattedWriter writerHelper = new FormattedWriter();
        this.writeClassDeclaration(writerHelper);
        this.writeMembers(writerHelper);
        writerHelper.writeln("}");
        writerHelper.writeln();
        return writerHelper.toString();
    }

    private void addMethod(String name, int modifiers, String returnType, String[] parameterNames, String[] parameterTypes, String[] exceptions, String[] body, String[] comments, List methodList) {
        String signature = IOJavaClassWriter.createMethodSignature(name, modifiers, returnType, parameterNames, parameterTypes, exceptions);
        FormattedWriter writerHelper = new FormattedWriter();
        int n = body != null ? body.length : 0;
        writerHelper.writeComments(comments);
        if (signature.length() > 0) {
            writerHelper.writeln(signature);
        }
        writerHelper.writeln("{");
        for (int i = 0; i < n; ++i) {
            writerHelper.writeln(1, body[i]);
        }
        writerHelper.writeln("}");
        methodList.add(writerHelper.toString());
    }

    private static String createMethodSignature(String name, int modifiers, String returnType, String[] parameterNames, String[] parameterTypes, String[] exceptions) {
        int i;
        int count = parameterNames != null ? parameterNames.length : 0;
        FormattedWriter writerHelper = new FormattedWriter();
        if (modifiers != 0) {
            writerHelper.write(Modifier.toString(modifiers) + " ");
        }
        writerHelper.write((String)(returnType != null ? returnType + " " : "") + name);
        writerHelper.write(" (");
        for (i = 0; i < count; ++i) {
            IOJavaClassWriter.writeListElement(i, count, parameterTypes[i] + " " + parameterNames[i], writerHelper);
        }
        writerHelper.write(")");
        int n = count = exceptions != null ? exceptions.length : 0;
        if (count > 0) {
            writerHelper.writeln();
            writerHelper.write(1, "throws ");
            for (i = 0; i < count; ++i) {
                IOJavaClassWriter.writeListElement(i, count, exceptions[i], writerHelper);
            }
        }
        return writerHelper.toString();
    }

    private static void writeListElement(int i, int count, String string, FormattedWriter writerHelper) {
        int indent;
        int n = indent = i == 0 ? 0 : 1;
        if (i == count - 1) {
            writerHelper.write(indent, string);
        } else {
            writerHelper.writeln(indent, string + COMMA_SEPARATOR);
        }
    }

    private List getMemberList(String memberType) {
        ArrayList memberList = null;
        if (!this._maintainCategories) {
            memberType = MIXED;
        }
        if ((memberList = (ArrayList)this._members.get(memberType)) == null) {
            memberList = new ArrayList();
            this._members.put(memberType, memberList);
        }
        return memberList;
    }

    private void writeClassDeclaration(FormattedWriter writerHelper) {
        writerHelper.write(this._classDeclarationBlock);
        if (this._superclass != null) {
            writerHelper.writeln(1, "extends " + this._superclass);
        }
        if (this._interfaces != null && this._interfaces.size() > 0) {
            writerHelper.write(1, "implements ");
            writerHelper.write(StringHelper.arrayToSeparatedList(this._interfaces, COMMA_SEPARATOR));
            writerHelper.writeln();
        }
        writerHelper.writeln("{");
    }

    private void writeMembers(FormattedWriter writerHelper) {
        if (this._maintainCategories) {
            writerHelper.writeList(1, this.getMemberList(FIELD));
            writerHelper.writeList(1, this.getMemberList(INITIALIZER));
            writerHelper.writeList(1, this.getMemberList(CONSTRUCTOR));
            writerHelper.writeList(1, this.getMemberList(METHOD));
            writerHelper.writeList(1, this.getMemberList(INNER_CLASS));
        } else {
            writerHelper.writeList(1, this.getMemberList(MIXED), true);
        }
    }
}

