/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.jmsspi;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.JMSObjFactory;
import com.sun.messaging.jmq.jmsclient.JMSXAQueueConnectionFactoryImpl;
import com.sun.messaging.jmq.jmsclient.JMSXATopicConnectionFactoryImpl;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedConnectionFactoryImpl;
import com.sun.messaging.jmq.jmsselector.InvalidJMSSelectorException;
import com.sun.messaging.jmq.jmsselector.JMSSelector;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import com.sun.messaging.jmq.jmsspi.PropertiesHolder;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.XAQueueConnectionFactory;
import jakarta.jms.XATopicConnectionFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JMSAdminImpl
implements JMSAdmin,
ExceptionListener {
    private static AdminResources ar = Globals.getAdminResources();
    public static final long DEFAULT_TIMEOUT = 5000L;
    private String adminuserName = null;
    private String adminPassword = null;
    private long timeout = 5000L;
    private QueueConnectionFactory qcf;
    private QueueConnection connection;
    private QueueSession session;
    private Queue requestQueue;
    private TemporaryQueue replyQueue;
    private QueueSender sender;
    protected QueueReceiver receiver;
    private AdministeredObject tmpDestination = null;
    private AdministeredObject tmpConnFactory = null;
    private boolean secureTransportUsed = false;
    private PropertiesHolder brokerPropertiesHolder;
    protected static final System.Logger logger = System.getLogger(JMSAdminImpl.class.getName());

    protected JMSAdminImpl(Properties connectionProps, PropertiesHolder brokerPropertiesHolder, String username, String adminPassword) throws JMSException {
        this.adminuserName = username;
        this.adminPassword = adminPassword;
        this.brokerPropertiesHolder = brokerPropertiesHolder;
        this.createFactory(connectionProps);
        String connType = connectionProps.getProperty("imqConnectionType", "");
        if (connType.equals("TLS") || connType.equals("SSL")) {
            this.secureTransportUsed = true;
        }
    }

    @Override
    public String getVersion() {
        Version version = new Version();
        return version.getJMSAdminSpiVersion();
    }

    @Override
    public Object createConnectionFactoryObject(int type, Map properties) throws JMSException {
        Object cf = null;
        Properties tmpProps = this.getProperties(properties);
        this.fillDefaultConnectionFactoryProperties(tmpProps);
        if (type == 1) {
            cf = JMSObjFactory.createTopicConnectionFactory(tmpProps);
        } else if (type == 0) {
            cf = JMSObjFactory.createQueueConnectionFactory(tmpProps);
        } else {
            throw new JMSException(ar.getKString("A4015"));
        }
        return cf;
    }

    @Override
    public Object createXAConnectionFactoryObject(int type, Map properties) throws JMSException {
        ConnectionFactory xcf = null;
        Properties tmpProps = this.getProperties(properties);
        this.fillDefaultConnectionFactoryProperties(tmpProps);
        if (type == 1) {
            xcf = new JMSXATopicConnectionFactoryImpl();
            JMSAdminImpl.setProperties(xcf, tmpProps);
        } else if (type == 0) {
            xcf = new JMSXAQueueConnectionFactoryImpl();
            JMSAdminImpl.setProperties(xcf, tmpProps);
        } else {
            throw new JMSException(ar.getKString("A4015"));
        }
        return xcf;
    }

    @Override
    public Object createDestinationObject(String destinationName, int type, Map properties) throws JMSException {
        Map props = properties;
        if (props == null) {
            props = new Properties();
        }
        props.put("imqDestinationName", destinationName);
        return this.createDestinationObject(type, props);
    }

    @Override
    public Object createDestinationObject(int type, Map properties) throws JMSException {
        if (properties == null || properties.get("imqDestinationName") == null) {
            throw new JMSException(ar.getKString("A4017"));
        }
        Object dest = null;
        Properties tmpProps = this.getProperties(properties);
        if (type == 1) {
            dest = JMSObjFactory.createTopic(tmpProps);
        } else if (type == 0) {
            dest = JMSObjFactory.createQueue(tmpProps);
        } else {
            throw new JMSException(ar.getKString("A4015"));
        }
        return dest;
    }

    @Override
    public Object wrapJMSConnectionFactoryObject(Object obj) throws JMSException {
        if (obj instanceof XAQueueConnectionFactory) {
            return new JMSXAWrappedConnectionFactoryImpl((XAQueueConnectionFactory)obj);
        }
        if (obj instanceof XATopicConnectionFactory) {
            return new JMSXAWrappedConnectionFactoryImpl((XATopicConnectionFactory)obj);
        }
        if (obj instanceof jakarta.jms.QueueConnectionFactory) {
            return new JMSXAWrappedConnectionFactoryImpl((jakarta.jms.QueueConnectionFactory)obj);
        }
        if (obj instanceof TopicConnectionFactory) {
            return new JMSXAWrappedConnectionFactoryImpl((TopicConnectionFactory)obj);
        }
        throw new JMSException(ar.getKString("A4016"));
    }

    @Override
    public void validateJMSSelector(String selector) throws JMSException {
        JMSSelector jmsselector = new JMSSelector();
        try {
            jmsselector.validateSelectorPattern(selector);
        }
        catch (InvalidJMSSelectorException e) {
            throw new InvalidSelectorException(e.getMessage());
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
    }

    @Override
    public String clientIDPropertyName() {
        return "imqConfiguredClientID";
    }

    @Override
    public Map getAllDestinationObjectProperties(int type) throws JMSException {
        if (this.tmpDestination == null) {
            this.tmpDestination = (AdministeredObject)JMSObjFactory.createTopic(new Properties());
        }
        Properties ret = new Properties();
        Enumeration e = this.tmpDestination.enumeratePropertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String propLabel = this.tmpDestination.getPropertyLabel(propName);
            ret.setProperty(propName, propLabel);
        }
        return ret;
    }

    @Override
    public Map getDisplayedDestinationObjectProperties(int type) throws JMSException {
        if (this.tmpDestination == null) {
            this.tmpDestination = (AdministeredObject)JMSObjFactory.createTopic(new Properties());
        }
        Properties ret = new Properties();
        String propName = "imqDestinationName";
        String propLabel = this.tmpDestination.getPropertyLabel(propName);
        ret.setProperty(propName, propLabel);
        return ret;
    }

    @Override
    public Map getAllConnectionFactoryObjectProperies(int type) throws JMSException {
        if (this.tmpConnFactory == null) {
            this.tmpConnFactory = (AdministeredObject)JMSObjFactory.createTopicConnectionFactory(new Properties());
        }
        Properties ret = new Properties();
        Enumeration e = this.tmpConnFactory.enumeratePropertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String propLabel = this.tmpConnFactory.getPropertyLabel(propName);
            ret.setProperty(propName, propLabel);
        }
        return ret;
    }

    @Override
    public Map getDisplayedConnectionFactoryObjectProperies(int type) throws JMSException {
        if (this.tmpConnFactory == null) {
            this.tmpConnFactory = (AdministeredObject)JMSObjFactory.createTopicConnectionFactory(new Properties());
        }
        Properties ret = new Properties();
        String propName = "imqBrokerHostName";
        String propLabel = this.tmpConnFactory.getPropertyLabel(propName);
        ret.setProperty(propName, propLabel);
        propName = "imqBrokerHostPort";
        propLabel = this.tmpConnFactory.getPropertyLabel(propName);
        ret.setProperty(propName, propLabel);
        propName = "imqConfiguredClientID";
        propLabel = this.tmpConnFactory.getPropertyLabel(propName);
        ret.setProperty(propName, propLabel);
        return ret;
    }

    @Override
    public void connectToProvider() throws JMSException {
        this.connection = this.qcf.createQueueConnection(this.adminuserName, this.adminPassword);
        this.connection.setExceptionListener((ExceptionListener)this);
        this.connection.start();
        this.session = this.connection.createQueueSession(false, 2);
        this.requestQueue = this.session.createQueue("__JMQAdmin");
        this.replyQueue = this.session.createTemporaryQueue();
        this.sender = this.session.createSender(this.requestQueue);
        this.sender.setDeliveryMode(1);
        this.receiver = this.session.createReceiver((Queue)this.replyQueue);
        this.hello();
    }

    @Override
    public void disconnectFromProvider() throws JMSException {
        block2: {
            this.sender.close();
            this.receiver.close();
            this.session.close();
            try {
                this.connection.close();
            }
            catch (JMSException jmse) {
                if (this.secureTransportUsed) break block2;
                throw jmse;
            }
        }
    }

    @Override
    public void createProviderDestination(String destinationName, int destinationType, Map properties) throws JMSException {
        ObjectMessage requestMesg = null;
        Message replyMesg = null;
        DestinationInfo di = new DestinationInfo();
        di.setName(destinationName);
        String qPolicy = null;
        int typeMask = JMSAdminImpl.getDestTypeMask(destinationType, null);
        if (properties != null) {
            if (properties.containsKey("queueDeliveryPolicy")) {
                qPolicy = (String)properties.get("queueDeliveryPolicy");
                typeMask = JMSAdminImpl.getDestTypeMask(destinationType, qPolicy);
            }
            if (properties.containsKey("maxNumActiveConsumers")) {
                Object tmp = null;
                String val = null;
                tmp = properties.get("maxNumActiveConsumers");
                if (tmp != null) {
                    if (!(tmp instanceof String)) {
                        JMSException jmse = new JMSException(ar.getString("A3163", DestType.toString(typeMask), destinationName) + "\n" + ar.getString("A3164", "maxNumActiveConsumers"));
                        throw jmse;
                    }
                    val = tmp;
                    try {
                        di.setMaxActiveConsumers(Integer.parseInt(val));
                    }
                    catch (Exception e) {
                        JMSException jmse = new JMSException(ar.getString("A3163", DestType.toString(typeMask), destinationName) + "\n" + ar.getString("A3107", val, "maxNumActiveConsumers"));
                        throw jmse;
                    }
                }
            }
        }
        di.setType(typeMask);
        requestMesg = this.session.createObjectMessage();
        requestMesg.setJMSReplyTo((Destination)this.replyQueue);
        requestMesg.setIntProperty("JMQMessageType", 10);
        requestMesg.setObject((Serializable)di);
        this.sender.send((Message)requestMesg);
        replyMesg = this.receiver.receive(this.timeout);
        replyMesg.acknowledge();
        this.checkReplyTypeStatus(replyMesg, 11);
    }

    @Override
    public void deleteProviderDestination(String destinationName, int type) throws JMSException {
        ObjectMessage requestMesg = null;
        Message replyMesg = null;
        requestMesg = this.session.createObjectMessage();
        requestMesg.setJMSReplyTo((Destination)this.replyQueue);
        requestMesg.setIntProperty("JMQMessageType", 12);
        requestMesg.setStringProperty("JMQDestination", destinationName);
        requestMesg.setIntProperty("JMQDestType", JMSAdminImpl.getDestTypeMask(type, null));
        this.sender.send((Message)requestMesg);
        replyMesg = this.receiver.receive(this.timeout);
        replyMesg.acknowledge();
        this.checkReplyTypeStatus(replyMesg, 13);
    }

    @Override
    public String[][] getProviderDestinations() throws JMSException {
        ObjectMessage mesg = null;
        mesg = this.session.createObjectMessage();
        mesg.setJMSReplyTo((Destination)this.replyQueue);
        mesg.setIntProperty("JMQMessageType", 20);
        this.sender.send((Message)mesg);
        mesg = (ObjectMessage)this.receiver.receive(this.timeout);
        mesg.acknowledge();
        this.checkReplyTypeStatus((Message)mesg, 21);
        Serializable obj = mesg.getObject();
        if (obj != null && obj instanceof Vector) {
            Vector dests = (Vector)obj;
            Vector<DestinationInfo> validDests = new Vector<DestinationInfo>();
            for (int i = 0; i < dests.size(); ++i) {
                DestinationInfo di = (DestinationInfo)dests.elementAt(i);
                if ("__JMQAdmin".equals(di.name) || "__JMQBridgeAdmin".equals(di.name) || DestType.isInternal(di.fulltype) || DestType.isTemporary(di.type)) continue;
                validDests.add(di);
            }
            int numElements = validDests.size();
            String[][] destinations = new String[2][numElements];
            for (int i = 0; i < numElements; ++i) {
                DestinationInfo di = (DestinationInfo)validDests.get(i);
                destinations[0][i] = di.name;
                destinations[1][i] = JMSAdminImpl.getDestinationType(di.type);
            }
            return destinations;
        }
        return null;
    }

    @Override
    public void startProvider(String iMQHome, String[] optArgs, String serverName) throws IOException, JMSException {
        String[] cmdLine = this.makeStartProviderCmdLine(iMQHome, optArgs, serverName, false);
        if (logger.isLoggable(System.Logger.Level.DEBUG)) {
            Object commandLineToLog = "";
            for (int i = 0; i < cmdLine.length; ++i) {
                commandLineToLog = (String)commandLineToLog + cmdLine[i] + " ";
            }
            logger.log(System.Logger.Level.DEBUG, "MQJMSRA: Starting LOCAL broker with command line: " + (String)commandLineToLog);
        }
        this.launchAndWatch(cmdLine);
    }

    @Override
    public String[] makeStartProviderCmdLine(String iMQHome, String[] optArgs, String serverName, boolean argsOnly) throws IOException, JMSException {
        Vector<Object> v = new Vector<Object>();
        String append = null;
        if (!argsOnly) {
            String iMQBrokerPath;
            if (File.separator.equals("\\")) {
                iMQBrokerPath = iMQHome + File.separator + "imqbrokersvc.exe";
                append = "-console";
            } else {
                iMQBrokerPath = iMQHome + File.separator + "imqbrokerd";
            }
            v.add(iMQBrokerPath);
        }
        String portStr = this.qcf.getProperty("imqBrokerHostPort");
        if (optArgs != null) {
            for (int i = 0; i < optArgs.length; ++i) {
                v.add(optArgs[i]);
            }
        }
        if (serverName != null) {
            v.add("-name");
            v.add(serverName);
        }
        if (append != null) {
            v.add(append);
        }
        v.add("-port");
        v.add(portStr);
        if (!logger.isLoggable(System.Logger.Level.DEBUG)) {
            v.add("-ttyerrors");
        }
        if (!argsOnly) {
            v.add("-managed");
            v.add("-read-stdin");
        }
        return v.toArray(new String[0]);
    }

    private void launchAndWatch(String[] cmdLine) throws IOException {
        Process p = Runtime.getRuntime().exec(cmdLine);
        BrokerWatcher brokerWatcher = new BrokerWatcher(p, cmdLine);
        brokerWatcher.setDaemon(true);
        brokerWatcher.start();
        boolean isError = true;
        StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), isError, "Local broker: ");
        errorGobbler.setDaemon(true);
        errorGobbler.start();
        isError = false;
        StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), isError, "Local broker: ");
        outputGobbler.setDaemon(true);
        outputGobbler.start();
        Properties brokerProps = this.brokerPropertiesHolder.getProperties();
        try {
            OutputStreamWriter osw = new OutputStreamWriter(p.getOutputStream());
            BufferedWriter bw = new BufferedWriter(osw);
            Enumeration<?> e = brokerProps.propertyNames();
            while (e.hasMoreElements()) {
                String thisPropertyName = (String)e.nextElement();
                String thisPropertyValue = brokerProps.getProperty(thisPropertyName);
                bw.write(thisPropertyName + "=" + thisPropertyValue);
                bw.newLine();
            }
            if (this.adminPassword != null) {
                bw.write("imq.imqcmd.password=" + this.adminPassword);
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException ioe) {
            logger.log(System.Logger.Level.ERROR, ioe.getMessage(), (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pingProvider() throws JMSException {
        Logger rootLogger = Logger.getLogger("jakarta.jms");
        Level savedLevel = rootLogger.getLevel();
        rootLogger.setLevel(Level.SEVERE);
        QueueConnection pingConn = null;
        try {
            pingConn = this.qcf.createQueueConnection(this.adminuserName, this.adminPassword);
        }
        finally {
            rootLogger.setLevel(savedLevel);
        }
        try {
            pingConn.setExceptionListener((ExceptionListener)this);
            pingConn.start();
        }
        finally {
            block12: {
                try {
                    pingConn.close();
                }
                catch (JMSException jmse) {
                    if (this.secureTransportUsed) break block12;
                    throw jmse;
                }
            }
        }
    }

    private String getProviderPropertyValue(String propName) throws JMSException {
        ObjectMessage requestMesg = null;
        ObjectMessage replyMesg = null;
        String propVal = null;
        requestMesg = this.session.createObjectMessage();
        requestMesg.setJMSReplyTo((Destination)this.replyQueue);
        requestMesg.setIntProperty("JMQMessageType", 54);
        this.sender.send((Message)requestMesg);
        replyMesg = (ObjectMessage)this.receiver.receive(this.timeout);
        replyMesg.acknowledge();
        this.checkReplyTypeStatus((Message)replyMesg, 55);
        Serializable obj = replyMesg.getObject();
        if (obj != null && obj instanceof Properties) {
            Properties props = (Properties)obj;
            propVal = props.getProperty(propName);
        }
        return propVal;
    }

    @Override
    public String getProviderInstanceName() throws JMSException {
        return this.getProviderPropertyValue("imq.instancename");
    }

    @Override
    public String getProviderVarHome() throws JMSException {
        return this.getProviderPropertyValue("imq.varhome");
    }

    @Override
    public void shutdownProvider() throws JMSException {
        try {
            this.tryToShutdownProvider();
        }
        catch (JMSException jmse) {
            if ("C4063".equals(jmse.getErrorCode()) || "C4059".equals(jmse.getErrorCode())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.connectToProvider();
                this.tryToShutdownProvider();
            }
            throw jmse;
        }
    }

    private void tryToShutdownProvider() throws JMSException {
        ObjectMessage requestMesg = this.session.createObjectMessage();
        requestMesg.setJMSReplyTo((Destination)this.replyQueue);
        requestMesg.setIntProperty("JMQMessageType", 38);
        this.sender.send((Message)requestMesg);
        Message replyMesg = this.receiver.receive(this.timeout);
        this.checkReplyTypeStatus(replyMesg, 39);
    }

    @Override
    public void restartProvider() throws JMSException {
        ObjectMessage requestMesg = null;
        Message replyMesg = null;
        requestMesg = this.session.createObjectMessage();
        requestMesg.setJMSReplyTo((Destination)this.replyQueue);
        requestMesg.setIntProperty("JMQMessageType", 38);
        requestMesg.setBooleanProperty("JMQRestart", true);
        this.sender.send((Message)requestMesg);
        replyMesg = this.receiver.receive(this.timeout);
        this.checkReplyTypeStatus(replyMesg, 39);
    }

    @Override
    public String getProviderHostName() throws JMSException {
        return this.qcf.getProperty("imqBrokerHostName");
    }

    @Override
    public String getProviderHostPort() throws JMSException {
        return this.qcf.getProperty("imqBrokerHostPort");
    }

    @Override
    public void deleteProviderInstance(String mqBinDir, String optArgs, String serverName) throws IOException, JMSException {
        int exitCode = 0;
        boolean interrupted = false;
        String iMQBrokerPath = File.separator.equals("\\") ? mqBinDir + File.separator + "imqbrokerd.exe" : mqBinDir + File.separator + "imqbrokerd";
        String cmdLine = iMQBrokerPath;
        if (optArgs != null) {
            cmdLine = cmdLine + " " + optArgs;
        }
        if (serverName != null) {
            cmdLine = cmdLine + " -name " + serverName;
        }
        cmdLine = cmdLine + " -remove instance -silent -force";
        Process p = Runtime.getRuntime().exec(cmdLine);
        p.getInputStream().close();
        p.getErrorStream().close();
        try {
            p.waitFor();
            exitCode = p.exitValue();
        }
        catch (InterruptedException iex) {
            interrupted = true;
        }
        if (interrupted) {
            throw new JMSException(ar.getKString("A4018", serverName));
        }
        switch (exitCode) {
            case 0: {
                break;
            }
            case 10: {
                throw new JMSException(ar.getKString("A4019", serverName));
            }
            case 11: {
                throw new JMSException(ar.getKString("A4020", serverName));
            }
            case 12: {
                throw new JMSException(ar.getKString("A4021", serverName));
            }
            case 13: {
                throw new JMSException(ar.getKString("A4022", serverName));
            }
            case 14: {
                throw new JMSException(ar.getKString("A4023", serverName));
            }
            default: {
                throw new JMSException(ar.getKString("A4024", serverName));
            }
        }
    }

    @Override
    public void deleteProviderInstance(String mqBinDir, String[] optArgs, String serverName) throws IOException, JMSException {
        int exitCode = 0;
        boolean interrupted = false;
        String iMQBrokerPath = File.separator.equals("\\") ? mqBinDir + File.separator + "imqbrokerd.exe" : mqBinDir + File.separator + "imqbrokerd";
        Vector<Object> v = new Vector<Object>();
        v.add(iMQBrokerPath);
        if (optArgs != null) {
            for (int i = 0; i < optArgs.length; ++i) {
                v.add(optArgs[i]);
            }
        }
        if (serverName != null) {
            v.add("-name");
            v.add(serverName);
        }
        v.add("-remove");
        v.add("instance");
        v.add("-silent");
        v.add("-force");
        String[] cmdLine = v.toArray(new String[0]);
        Process p = Runtime.getRuntime().exec(cmdLine);
        p.getInputStream().close();
        p.getErrorStream().close();
        try {
            p.waitFor();
            exitCode = p.exitValue();
        }
        catch (InterruptedException iex) {
            interrupted = true;
        }
        if (interrupted) {
            throw new JMSException(ar.getKString("A4018", serverName));
        }
        switch (exitCode) {
            case 0: {
                break;
            }
            case 10: {
                throw new JMSException(ar.getKString("A4019", serverName));
            }
            case 11: {
                throw new JMSException(ar.getKString("A4020", serverName));
            }
            case 12: {
                throw new JMSException(ar.getKString("A4021", serverName));
            }
            case 13: {
                throw new JMSException(ar.getKString("A4022", serverName));
            }
            case 14: {
                throw new JMSException(ar.getKString("A4023", serverName));
            }
            default: {
                throw new JMSException(ar.getKString("A4024", serverName));
            }
        }
    }

    private void hello() throws JMSException {
        ObjectMessage requestMesg = null;
        Message replyMesg = null;
        requestMesg = this.session.createObjectMessage();
        requestMesg.setJMSReplyTo((Destination)this.replyQueue);
        requestMesg.setIntProperty("JMQMessageType", 28);
        this.sender.send((Message)requestMesg);
        replyMesg = this.receiver.receive(this.timeout);
        replyMesg.acknowledge();
        this.checkReplyTypeStatus(replyMesg, 29);
    }

    private Properties getProperties(Map properties) {
        Properties tmpProps = null;
        if (properties == null) {
            tmpProps = new Properties();
        } else if (properties instanceof Properties) {
            tmpProps = (Properties)properties;
        } else {
            tmpProps = new Properties();
            for (Map.Entry entry : properties.entrySet()) {
                tmpProps.put(entry.getKey(), entry.getValue());
            }
        }
        return tmpProps;
    }

    private static void setProperties(AdministeredObject obj, Properties objProps) throws JMSException {
        Enumeration<?> e = objProps.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String value = objProps.getProperty(propName);
            if (value == null) continue;
            obj.setProperty(propName, value);
        }
    }

    private void createFactory(Properties connectionProps) throws JMSException {
        this.qcf = new QueueConnectionFactory();
        this.qcf.setConnectionType("ADMIN");
        Enumeration<?> e = connectionProps.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String value = connectionProps.getProperty(propName);
            if (value == null) continue;
            this.qcf.setProperty(propName, value);
        }
    }

    private void fillDefaultConnectionFactoryProperties(Properties props) throws JMSException {
        String val;
        if (props.getProperty("imqBrokerHostName") == null && (val = this.qcf.getProperty("imqBrokerHostName")) != null) {
            props.setProperty("imqBrokerHostName", val);
        }
        if (props.getProperty("imqBrokerHostPort") == null && (val = this.qcf.getProperty("imqBrokerHostPort")) != null) {
            props.setProperty("imqBrokerHostPort", val);
        }
    }

    private static int getDestTypeMask(int type, String policy) {
        int mask = -1;
        if (type == 1) {
            mask = 2;
        } else if (type == 0) {
            mask = 1;
        }
        if (policy == null) {
            return mask;
        }
        if (type == 0) {
            if (policy.equals("s")) {
                mask |= 0x100;
            } else if (policy.equals("f")) {
                mask |= 0x400;
            } else if (policy.equals("r")) {
                mask |= 0x200;
            }
        }
        return mask;
    }

    private static String getDestinationType(int mask) {
        if (DestType.isTopic(mask)) {
            return String.valueOf(1);
        }
        if (DestType.isQueue(mask)) {
            return String.valueOf(0);
        }
        return String.valueOf(-1);
    }

    private void checkReplyTypeStatus(Message mesg, int msgType) throws JMSException {
        int actualMsgType = -1;
        int actualReplyStatus = -1;
        if (mesg == null && msgType == 39) {
            return;
        }
        actualMsgType = mesg.getIntProperty("JMQMessageType");
        actualReplyStatus = mesg.getIntProperty("JMQStatus");
        if (msgType == actualMsgType && actualReplyStatus == 200) {
            return;
        }
        String error = null;
        try {
            error = mesg.getStringProperty("JMQErrorString");
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new JMSException(error);
    }

    public void onException(JMSException jmse) {
    }

    class BrokerWatcher
    extends Thread {
        Process p;
        String[] cmdLine;

        BrokerWatcher(Process p, String[] cmdLine) {
            this.p = p;
            this.cmdLine = cmdLine;
        }

        @Override
        public void run() {
            logger.log(System.Logger.Level.DEBUG, "BrokerWatcher started");
            try {
                int status = this.p.waitFor();
                logger.log(System.Logger.Level.DEBUG, "BrokerWatcher: Broker returned with status=" + status);
                if (status == 255) {
                    JMSAdminImpl.this.launchAndWatch(this.cmdLine);
                    logger.log(System.Logger.Level.DEBUG, "BrokerWatcher terminating after restarting broker");
                }
                logger.log(System.Logger.Level.DEBUG, "BrokerWatcher terminating after normal exit");
            }
            catch (InterruptedException e) {
                logger.log(System.Logger.Level.WARNING, "InterruptedException watching broker: " + e.getMessage());
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.WARNING, "Error restarting broker: " + e.getMessage());
            }
        }
    }

    static class StreamGobbler
    extends Thread {
        InputStream is;
        boolean isError;
        String prefix;

        StreamGobbler(InputStream is, boolean isError, String prefix) {
            this.is = is;
            this.isError = isError;
            this.prefix = prefix;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                Object message = this.prefix;
                int noOfLines = 0;
                while ((line = br.readLine()) != null) {
                    if (++noOfLines > 1) {
                        message = (String)message + "\n";
                    }
                    message = (String)message + line;
                }
                if (noOfLines > 0) {
                    if (this.isError) {
                        logger.log(System.Logger.Level.WARNING, (String)message);
                    } else {
                        logger.log(System.Logger.Level.INFO, (String)message);
                    }
                }
            }
            catch (IOException ioe) {
                logger.log(System.Logger.Level.ERROR, ioe.getMessage(), (Throwable)ioe);
            }
        }
    }
}

