/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.security.ee.authentication.jakarta.WebServicesDelegate;
import com.sun.enterprise.security.webservices.LogUtils;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.wss.provider.wsit.PacketMessageInfo;
import jakarta.inject.Singleton;
import jakarta.security.auth.message.MessageInfo;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.Node;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class WebServicesDelegateImpl
implements WebServicesDelegate {
    protected static final Logger _logger = LogUtils.getLogger();
    private static final String DEFAULT_WEBSERVICES_PROVIDER = "com.sun.xml.wss.provider.wsit.WSITAuthConfigProvider";

    public MessageSecurityBindingDescriptor getBinding(ServiceReferenceDescriptor serviceReferenceDescriptor, Map properties) {
        ServiceRefPortInfo portInfo;
        MessageSecurityBindingDescriptor binding = null;
        WSDLPort port = (WSDLPort)properties.get("WSDL_MODEL");
        QName portName = null;
        if (port != null) {
            portName = port.getName();
        }
        if (portName != null && (portInfo = serviceReferenceDescriptor.getPortInfoByPort(portName)) != null) {
            binding = portInfo.getMessageSecurityBinding();
        }
        return binding;
    }

    public String getDefaultWebServicesProvider() {
        return DEFAULT_WEBSERVICES_PROVIDER;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        QName name;
        WSDLBoundOperation boundOperation;
        WSDLPort port;
        Message message;
        if (!(messageInfo instanceof PacketMessageInfo)) {
            return this.getOpName((SOAPMessage)messageInfo.getRequestMessage());
        }
        String authContextID = null;
        PacketMessageInfo pmi = (PacketMessageInfo)messageInfo;
        Packet requestPacket = pmi.getRequestPacket();
        if (requestPacket != null && (message = requestPacket.getMessage()) != null && (port = (WSDLPort)messageInfo.getMap().get("WSDL_MODEL")) != null && (boundOperation = message.getOperation(port)) != null && (name = boundOperation.getName()) != null) {
            authContextID = name.getLocalPart();
        }
        return authContextID;
    }

    private String getOpName(SOAPMessage message) {
        Name name;
        String[] actions;
        if (message == null) {
            return null;
        }
        String opName = null;
        MimeHeaders headers = message.getMimeHeaders();
        if (headers != null && (actions = headers.getHeader("SOAPAction")) != null && actions.length > 0 && (opName = actions[0]) != null && opName.equals("\"\"")) {
            opName = null;
        }
        if (opName == null && (name = this.getName(message)) != null) {
            opName = name.getLocalName();
        }
        return opName;
    }

    private Name getName(SOAPMessage message) {
        Name name;
        block4: {
            name = null;
            SOAPPart soap = message.getSOAPPart();
            if (soap != null) {
                try {
                    SOAPBody body;
                    SOAPEnvelope envelope = soap.getEnvelope();
                    if (envelope == null || (body = envelope.getBody()) == null) break block4;
                    Iterator it = body.getChildElements();
                    while (it.hasNext()) {
                        Node node = (Node)it.next();
                        if (!(node instanceof SOAPElement)) continue;
                        name = ((SOAPElement)node).getElementName();
                        break;
                    }
                }
                catch (SOAPException se) {
                    _logger.log(Level.FINE, "WSS: Unable to get SOAP envelope", se);
                }
            }
        }
        return name;
    }
}

