/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.enterprise.common.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.security.CORBAObjectPermission;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.security.jacc.PolicyFactory;
import java.net.Socket;
import java.security.Permission;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.Object;

@Service
@Singleton
public class SecurityContextUtil
implements PostConstruct {
    private static final Logger LOG = LogDomains.getLogger(SecurityContextUtil.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    public static final int STATUS_PASSED = 0;
    public static final int STATUS_FAILED = 1;
    public static final int STATUS_RETRY = 2;
    private static final String IS_A = "_is_a";
    @Inject
    private GlassFishORBHelper orbHelper;
    @Inject
    private SecurityMechanismSelector securityMechanismSelector;

    public void postConstruct() {
    }

    public SecurityContext getSecurityContext(Object effective_target) throws InvalidMechanismException, InvalidIdentityTokenException {
        IOR ior = ((ORB)this.orbHelper.getORB()).getIOR(effective_target, false);
        if (StubAdapter.isStub((java.lang.Object)effective_target) && StubAdapter.isLocal((java.lang.Object)effective_target)) {
            ConnectionExecutionContext.setClientThreadID(Thread.currentThread().getId());
            return null;
        }
        try {
            return this.securityMechanismSelector.selectSecurityContext(ior);
        }
        catch (InvalidIdentityTokenException | InvalidMechanismException e) {
            throw e;
        }
        catch (SecurityMechanismException e) {
            throw new RuntimeException("Could not select a security context.", e);
        }
    }

    public static void receivedReply(int reply_status, Object effective_target) {
        if (reply_status == 1) {
            LOG.log(Level.FINE, "Failed status");
            throw new RuntimeException("Target did not accept security context");
        }
        if (reply_status == 2) {
            LOG.log(Level.FINE, "Retry status");
        } else {
            LOG.log(Level.FINE, "Passed status");
        }
    }

    public int setSecurityContext(SecurityContext context, byte[] object_id, String method, Socket socket) {
        LOG.log(Level.FINE, "ABOUT TO EVALUATE TRUST");
        try {
            SecurityContext securityContext = this.securityMechanismSelector.evaluateTrust(context, object_id, socket);
            if (securityContext == null) {
                return 0;
            }
            Class credentialClass = null;
            credentialClass = securityContext.authcls == null ? securityContext.identcls : securityContext.authcls;
            this.authenticate(securityContext.subject, credentialClass);
            if (this.authorizeCORBA(object_id, method)) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            if (!method.equals(IS_A)) {
                LOG.log(Level.FINE, "Authentication Exception", e);
            }
            return 1;
        }
    }

    private boolean authorizeCORBA(byte[] object_id, String method) throws Exception {
        ProtocolManager protocolManager = this.orbHelper.getProtocolManager();
        if (protocolManager == null) {
            return true;
        }
        if (protocolManager.getEjbDescriptor(object_id) != null) {
            return true;
        }
        com.sun.enterprise.security.SecurityContext securityContext = com.sun.enterprise.security.SecurityContext.getCurrent();
        boolean result = PolicyFactory.getPolicyFactory().getPolicy().implies((Permission)new CORBAObjectPermission("*", method), securityContext.getPrincipalSet());
        LOG.log(Level.FINE, "CORBA Object permission evaluation result={0} for method={1}", new java.lang.Object[]{result, method});
        return result;
    }

    public void sendingReply(SecurityContext context) {
    }

    public static void unsetSecurityContext(boolean isLocal) {
        if (!isLocal) {
            com.sun.enterprise.security.SecurityContext.setCurrent(null);
        }
    }

    private void authenticate(Subject subject, Class<?> credentialClass) throws SecurityMechanismException {
        try {
            LoginContextDriver.login((Subject)subject, credentialClass);
        }
        catch (Exception e) {
            throw new SecurityMechanismException("Cannot login user: " + e.getMessage(), e);
        }
    }
}

