/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.security.spi;

import java.security.Principal;
import java.util.function.Consumer;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.security.spi.SecurityContext;

public interface SecurityServices
extends Service {
    public Principal getPrincipal();

    default public SecurityContext getSecurityContext() {
        return SecurityContext.NOOP_SECURITY_CONTEXT;
    }

    default public Consumer<Runnable> getSecurityContextAssociator() {
        SecurityContext securityContext = this.getSecurityContext();
        return action -> {
            try {
                securityContext.associate();
                action.run();
            }
            finally {
                securityContext.dissociate();
                securityContext.close();
            }
        };
    }
}

