/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.interceptor.CdiInterceptorFactory;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.interceptor.WeldInvocationContext;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.proxy.WeldInvocationContextImpl;
import org.jboss.weld.interceptor.reader.InterceptorMetadataImpl;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Interceptors;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptorImpl<T>
extends ManagedBean<T>
implements Interceptor<T> {
    private final InterceptorClassMetadata<T> interceptorMetadata = this.initInterceptorMetadata();
    private final Set<Annotation> interceptorBindingTypes;
    private final boolean serializable;

    public static <T> InterceptorImpl<T> of(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        return new InterceptorImpl<T>(attributes, type, beanManager);
    }

    protected InterceptorImpl(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        super(attributes, type, new StringBeanIdentifier(BeanIdentifiers.forInterceptor(type)), beanManager);
        this.serializable = type.isSerializable();
        this.interceptorBindingTypes = Interceptors.mergeBeanInterceptorBindings(beanManager, this.getEnhancedAnnotated(), this.getStereotypes()).uniqueValues();
    }

    private InterceptorClassMetadata<T> initInterceptorMetadata() {
        CdiInterceptorFactory reference = new CdiInterceptorFactory(this);
        return new InterceptorMetadataImpl(this.getBeanClass(), reference, InterceptorMetadataUtils.buildMethodMap(this.getEnhancedAnnotated(), false, this.getBeanManager()));
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindingTypes;
    }

    public InterceptorClassMetadata<T> getInterceptorMetadata() {
        return this.interceptorMetadata;
    }

    @Override
    public Object intercept(jakarta.enterprise.inject.spi.InterceptionType type, T instance, InvocationContext ctx) {
        InterceptionType interceptionType = InterceptionType.valueOf(type.name());
        List<InterceptorMethodInvocation> methodInvocations = this.interceptorMetadata.getInterceptorInvocation(instance, interceptionType).getInterceptorMethodInvocations();
        Set<Annotation> interceptorBindings = null;
        if (ctx instanceof WeldInvocationContext) {
            interceptorBindings = ((WeldInvocationContext)Reflections.cast(ctx)).getInterceptorBindings();
        }
        try {
            return new WeldInvocationContextImpl(ctx, methodInvocations, interceptorBindings, null).proceed();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    @Override
    public boolean intercepts(jakarta.enterprise.inject.spi.InterceptionType type) {
        return this.interceptorMetadata.isEligible(InterceptionType.valueOf(type.name()));
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        super.initializeAfterBeanDiscovery();
    }

    @Override
    public String toString() {
        return "Interceptor [" + String.valueOf(this.getBeanClass()) + " intercepts " + Formats.formatAnnotations(this.getInterceptorBindings()) + "]";
    }
}

