/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.copying;

import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import org.eclipse.persistence.descriptors.copying.AbstractCopyPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.sessions.Session;

public class RecordCopyPolicy
extends AbstractCopyPolicy {
    @Override
    public Object buildClone(Object domainObject, Session session) throws DescriptorException {
        return this.cloneRecord((Record)domainObject);
    }

    @Override
    public boolean buildsNewInstance() {
        return true;
    }

    private <R extends Record> R cloneRecord(R template) {
        try {
            ArrayList types = new ArrayList();
            ArrayList<Object> values = new ArrayList<Object>();
            for (RecordComponent component : template.getClass().getRecordComponents()) {
                types.add(component.getType());
                Object value = component.getAccessor().invoke(template, new Object[0]);
                if (value instanceof Record) {
                    value = this.cloneRecord((Record)value);
                }
                values.add(value);
            }
            Constructor<?> canonical = template.getClass().getDeclaredConstructor((Class[])types.toArray(Class[]::new));
            Record result = (Record)canonical.newInstance(values.toArray(Object[]::new));
            return (R)result;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Record clone failed: " + String.valueOf(e), e);
        }
    }
}

