/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.universal.process.KillNotPossibleException;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.time.Duration;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="stop-local-instance")
@PerLookup
public class StopLocalInstanceCommand
extends LocalInstanceCommand {
    @Param(optional=true, defaultValue="true")
    private Boolean force;
    @Param(name="instance_name", primary=true, optional=true)
    private String userArgInstanceName;
    @Param(optional=true, defaultValue="false")
    private Boolean kill;

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.instanceName = this.userArgInstanceName;
        super.validate();
    }

    @Override
    protected boolean mkdirs(File f) {
        return false;
    }

    @Override
    protected void initInstance() throws CommandException {
        super.initInstance();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        File serverDir = this.getServerDirs().getServerDir();
        if (serverDir == null || !serverDir.isDirectory()) {
            return this.noSuchInstance();
        }
        if (this.getServerDirs().getLocalPassword() == null) {
            return this.instanceNotRunning();
        }
        HostAndPort addr = this.getAdminAddress(this.getServerDirs().getServerName());
        this.programOpts.setHostAndPort(addr);
        logger.log(Level.FINER, "Stopping server at {0}", addr);
        if (!ProcessUtils.isAlive((File)this.getServerDirs().getPidFile())) {
            return this.instanceNotRunning();
        }
        logger.finer("It's the correct Instance");
        this.doCommand();
        return 0;
    }

    protected int instanceNotRunning() throws CommandException {
        logger.log(Level.FINE, "instanceNotRunning()");
        if (this.kill.booleanValue()) {
            try {
                File lastPid = this.getServerDirs().getLastPidFile();
                ProcessUtils.kill((File)lastPid, (Duration)Duration.ofMillis(CLIConstants.DEATH_TIMEOUT_MS), (!this.programOpts.isTerse() ? 1 : 0) != 0);
            }
            catch (KillNotPossibleException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return -1;
            }
        }
        logger.warning(Strings.get("StopInstance.instanceNotRunning"));
        return 0;
    }

    private int noSuchInstance() {
        logger.warning(Strings.get("Instance.noSuchInstance"));
        return 0;
    }

    protected void doCommand() throws CommandException {
        this.setLocalPassword();
        this.programOpts.setInteractive(false);
        Long pid = ProcessUtils.loadPid((File)this.getServerDirs().getPidFile());
        boolean printDots = !this.programOpts.isTerse();
        Duration timeout = Duration.ofMillis(CLIConstants.DEATH_TIMEOUT_MS);
        RemoteCLICommand cmd = new RemoteCLICommand("_stop-instance", this.programOpts, this.env);
        try {
            boolean dead;
            cmd.executeAndReturnOutput(new String[]{"_stop-instance", "--force", this.force.toString()});
            if (printDots) {
                System.out.print(Strings.get("StopInstance.waitForDeath") + " ");
            }
            if (!(dead = ProcessUtils.waitWhileIsAlive((long)pid, (Duration)timeout, (boolean)printDots))) {
                throw new CommandException(Strings.get("StopInstance.instanceNotDead", CLIConstants.DEATH_TIMEOUT_MS / 1000L));
            }
        }
        catch (Exception e) {
            logger.log(Level.CONFIG, "Remote stop-instance call failed.", e);
            if (this.kill.booleanValue()) {
                try {
                    File prevPid = this.getServerDirs().getLastPidFile();
                    ProcessUtils.kill((File)prevPid, (Duration)timeout, (boolean)printDots);
                    return;
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
            }
            throw e;
        }
    }
}

