/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.util;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;

public final class ImplUtil {
    public static void unregisterAMXMBeans(AMXProxy top) {
        if (top == null) {
            throw new IllegalArgumentException();
        }
        MBeanServer mbeanServer = (MBeanServer)top.extra().mbeanServerConnection();
        Set<AMXProxy> children = top.extra().childrenSet();
        if (children != null) {
            for (AMXProxy amx : children) {
                ImplUtil.unregisterAMXMBeans(amx);
            }
        }
        ImplUtil.unregisterOneMBean(mbeanServer, top.objectName());
    }

    public static void unregisterAMXMBeans(MBeanServer mbs, ObjectName objectName) {
        ImplUtil.unregisterAMXMBeans(ProxyFactory.getInstance(mbs).getProxy(objectName, AMXProxy.class));
    }

    public static boolean unregisterOneMBean(MBeanServer mbeanServer, ObjectName objectName) {
        boolean success = false;
        try {
            mbeanServer.unregisterMBean(objectName);
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }
}

