/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.util;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ClassLoadingUtility;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.logging.LogDomains;
import java.sql.Driver;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;

public class JdbcResourcesUtil {
    private static final Logger LOG = LogDomains.getLogger(JdbcResourcesUtil.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static volatile JdbcResourcesUtil jdbcResourcesUtil;
    private ConnectorRuntime runtime;

    private JdbcResourcesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JdbcResourcesUtil createInstance() {
        if (jdbcResourcesUtil != null) return jdbcResourcesUtil;
        Class<JdbcResourcesUtil> clazz = JdbcResourcesUtil.class;
        synchronized (JdbcResourcesUtil.class) {
            if (jdbcResourcesUtil != null) return jdbcResourcesUtil;
            jdbcResourcesUtil = new JdbcResourcesUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return jdbcResourcesUtil;
        }
    }

    private ConnectorRuntime getRuntime() {
        if (this.runtime == null) {
            this.runtime = ConnectorRuntime.getRuntime();
        }
        return this.runtime;
    }

    public static Collection<BindableResource> getResourcesOfPool(Resources resources, SimpleJndiName connectionPoolName) {
        HashSet<BindableResource> resourcesReferringPool = new HashSet<BindableResource>();
        ResourcePool pool = JdbcResourcesUtil.getResourceByName(resources, ResourcePool.class, connectionPoolName);
        if (pool != null) {
            LOG.log(Level.FINE, "Found pool: {0}", pool.getName());
            Collection bindableResources = resources.getResources(JdbcResource.class);
            for (JdbcResource resource : bindableResources) {
                if (!resource.getPoolName().equals(connectionPoolName.toString())) continue;
                resourcesReferringPool.add((BindableResource)resource);
            }
        }
        return resourcesReferringPool;
    }

    public static ResourcePool getResourceByName(Resources resources, Class<ResourcePool> type, SimpleJndiName name) {
        return (ResourcePool)resources.getResourceByName(type, name);
    }

    public String getRANameofJdbcConnectionPool(JdbcConnectionPool pool) {
        String dsRAName = "__ds_jdbc_ra";
        Class clz = null;
        if (pool.getDatasourceClassname() != null && !pool.getDatasourceClassname().isEmpty()) {
            try {
                clz = ClassLoadingUtility.loadClass(pool.getDatasourceClassname());
            }
            catch (ClassNotFoundException cnfe) {
                Object[] params = new Object[]{dsRAName, pool.getName()};
                LOG.log(Level.WARNING, "using.default.ds", params);
                return dsRAName;
            }
        }
        if (pool.getDriverClassname() != null && !pool.getDriverClassname().isEmpty()) {
            try {
                clz = ClassLoadingUtility.loadClass(pool.getDriverClassname());
            }
            catch (ClassNotFoundException cnfe) {
                Object[] params = new Object[]{dsRAName, pool.getName()};
                LOG.log(Level.WARNING, "using.default.ds", params);
                return dsRAName;
            }
        }
        if (clz != null) {
            if ("javax.sql.XADataSource".equals(pool.getResType()) && XADataSource.class.isAssignableFrom(clz)) {
                return "__xa_jdbc_ra";
            }
            if ("javax.sql.ConnectionPoolDataSource".equals(pool.getResType()) && ConnectionPoolDataSource.class.isAssignableFrom(clz)) {
                return "__cp_jdbc_ra";
            }
            if ("java.sql.Driver".equals(pool.getResType()) && Driver.class.isAssignableFrom(clz)) {
                return "__dm_jdbc_ra";
            }
            if ("javax.sql.DataSource".equals(pool.getResType()) && DataSource.class.isAssignableFrom(clz)) {
                return dsRAName;
            }
        }
        Object[] params = new Object[]{dsRAName, pool.getName()};
        LOG.log(Level.WARNING, "using.default.ds", params);
        return dsRAName;
    }

    public JdbcConnectionPool getJdbcConnectionPoolOfResource(ResourceInfo resourceInfo) {
        JdbcResource resource = null;
        JdbcConnectionPool pool = null;
        Resources resources = this.getResources(resourceInfo);
        if (resources != null && (resource = (JdbcResource)resources.getResourceByName(JdbcResource.class, resourceInfo.getName())) != null) {
            SimpleJndiName poolName = new SimpleJndiName(resource.getPoolName());
            pool = (JdbcConnectionPool)resources.getResourceByName(JdbcConnectionPool.class, poolName);
        }
        return pool;
    }

    private Resources getResources(ResourceInfo resourceInfo) {
        return this.getRuntime().getResources(resourceInfo);
    }

    public boolean isJdbcPoolReferredInServerInstance(PoolInfo poolInfo) {
        Collection jdbcResources = this.getRuntime().getResources(poolInfo).getResources(JdbcResource.class);
        for (JdbcResource resource : jdbcResources) {
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)resource);
            ResourcesUtil util = ResourcesUtil.createInstance();
            if (!resource.getPoolName().equals(poolInfo.getName().toString()) || !util.isReferenced(resourceInfo) || !util.isEnabled((BindableResource)resource)) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("pool " + String.valueOf(poolInfo) + "resource " + String.valueOf(resourceInfo) + " referred " + util.isReferenced(resourceInfo));
                LOG.fine("JDBC resource " + resource.getJndiName() + "refers " + String.valueOf(poolInfo) + "in this server instance and is enabled");
            }
            return true;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("No JDBC resource refers [ " + String.valueOf(poolInfo) + " ] in this server instance");
        }
        return false;
    }
}

