/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.log;

import com.sun.messaging.jmq.resources.SharedResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Contract;

@Contract
@PerLookup
public abstract class LogHandler {
    public int levels = 120;
    protected Logger logger = null;
    protected static final SharedResources rb = SharedResources.getResources();
    protected String name = null;
    private boolean allowForceMessage = true;

    public boolean isAllowForceMessage() {
        return this.allowForceMessage;
    }

    protected void setAllowForceMessage(boolean allowForceMessage) {
        this.allowForceMessage = allowForceMessage;
    }

    public void acceptAllLevels() {
        this.levels = 127;
    }

    protected void setLevels(String levelList) {
        this.levels = 0;
        this.levels = 64;
        StringTokenizer token = new StringTokenizer(levelList, "|", false);
        while (token.hasMoreElements()) {
            String s = token.nextToken();
            if (s.equals("ALL")) {
                this.acceptAllLevels();
                break;
            }
            if (s.equals("NONE")) {
                this.levels = 0;
                break;
            }
            if (s.equals("NOFORCE")) {
                this.setAllowForceMessage(false);
                continue;
            }
            this.levels |= Logger.levelStrToInt(s);
        }
    }

    public void init(Logger parent) {
        this.logger = parent;
        this.acceptAllLevels();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void flush() {
    }

    public abstract void configure(Properties var1, String var2);

    public abstract void publish(int var1, String var2) throws IOException;

    public abstract void open() throws IOException;

    public abstract void close();
}

