/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.pool;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.pool.ThreadPool;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.util.Hashtable;
import java.util.TimerTask;

public abstract class BasicRunnable
implements Runnable {
    private static boolean DEBUG = false;
    public static final int B_STAY_RUNNING = 0;
    public static final int B_TIMEOUT_THREAD = 1;
    public static final int B_DESTROY_THREAD = 2;
    protected int behavior = 0;
    public static final int RUN_STARTING = 0;
    public static final int RUN_READY = 1;
    public static final int RUN_PREASSIGNED = 2;
    public static final int RUN_ASSIGNED = 3;
    public static final int RUN_SUSPENDED = 4;
    public static final int RUN_CRITICAL = 5;
    public static final int RUN_DESTROYING = 6;
    public static final int RUN_DESTROYED = 7;
    protected int state = 0;
    boolean suspended = false;
    public static final long DEFAULT_TIMEOUT = Globals.getConfig().getIntProperty("imq.thread.expiration.timeout", 120);
    private long timeout = DEFAULT_TIMEOUT;
    private ThreadExpiration expr = null;
    protected Logger logger = Globals.getLogger();
    protected ThreadPool tctrl;
    protected int id;

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public BasicRunnable(int id, ThreadPool tctrl) {
        this(id, tctrl, 0);
    }

    public BasicRunnable(int id, ThreadPool tctrl, int behavior) {
        if (DEBUG) {
            this.logger.log(4, "BasicRunnable: created BasicRunnable {0}:{1}", (Object)String.valueOf(id), (Object)tctrl.toString());
        }
        this.tctrl = tctrl;
        this.id = id;
        this.setThreadBehavior(behavior);
    }

    public String toString() {
        String str = "BasicRunnable[" + this.id + " , " + BasicRunnable.behaviorToString(this.behavior) + " ," + this.stateToString(this.state) + "]";
        return str;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("state", this.stateToString(this.state));
        ht.put("behavior", BasicRunnable.behaviorToString(this.behavior));
        ht.put("suspended", this.suspended);
        ht.put("id", this.id);
        return ht;
    }

    protected String stateToString(int state) {
        switch (state) {
            case 0: {
                return "RUN_STARTING";
            }
            case 1: {
                if (this.suspended) {
                    return "RUN_READY(suspended)";
                }
                return "RUN_READY ";
            }
            case 2: {
                if (this.suspended) {
                    return "RUN_PREASSIGNED(suspended)";
                }
                return "RUN_PREASSIGNED ";
            }
            case 3: {
                if (this.suspended) {
                    return "RUN_ASSIGNED(suspended)";
                }
                return "RUN_ASSIGNED ";
            }
            case 5: {
                if (this.suspended) {
                    return "RUN_CRITICAL(suspended)";
                }
                return "RUN_CRITICAL ";
            }
            case 6: {
                return "RUN_DESTROYING ";
            }
            case 7: {
                return "RUN_DESTROYED";
            }
        }
        return "RUN_UNKNOWN(" + state + ")";
    }

    protected static String behaviorToString(int behavior) {
        switch (behavior) {
            case 0: {
                return "B_STAY_RUNNING";
            }
            case 1: {
                return "B_TIMEOUT_THREAD";
            }
            case 2: {
                return "B_DESTROY_THREAD";
            }
        }
        return "B_UNKNOWN(" + behavior + ")";
    }

    public synchronized boolean available() {
        return this.state == 1;
    }

    public boolean hasBeenDestroyed() {
        return this.state == 7;
    }

    public synchronized boolean waitOnDestroy(long time) {
        if (this.state >= 7) {
            return true;
        }
        if (this.state < 6) {
            this.destroy();
        }
        while (this.state == 5) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        return this.hasBeenDestroyed();
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    public synchronized void setState(int newstate) {
        if (this.state == newstate) {
            return;
        }
        if (this.state >= 7) {
            return;
        }
        if (this.state >= 6 && newstate < 6) {
            return;
        }
        if (this.behavior == 1) {
            if (newstate == 1) {
                this.startTimeout();
            } else {
                this.cancelTimeout();
            }
        }
        this.state = newstate;
        if (this.state >= 6 || this.state == 3) {
            this.notifyAll();
        }
    }

    public void setThreadBehavior(int newbehavior) {
        if (this.behavior == newbehavior) {
            return;
        }
        int oldbehavior = this.behavior;
        this.behavior = newbehavior;
        if (oldbehavior == 1) {
            this.cancelTimeout();
        } else if (newbehavior == 1 && this.state == 1) {
            this.startTimeout();
        } else if (newbehavior == 2) {
            this.destroy();
        }
    }

    public synchronized void startTimeout() {
        if (this.behavior != 1) {
            throw new ArrayIndexOutOfBoundsException(Globals.getBrokerResources().getString("B4117", "trying to timeout a non-TIMEOUT thread"));
        }
        if (this.expr != null) {
            this.cancelTimeout();
        }
        MQTimer timer = Globals.getTimer();
        this.expr = new ThreadExpiration(this);
        long time = this.timeout * 1000L;
        try {
            timer.scheduleAtFixedRate((TimerTask)this.expr, time, time);
        }
        catch (IllegalStateException ex) {
            this.logger.log(8, "Timer shutting down ", (Throwable)ex);
        }
    }

    public synchronized void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private synchronized void cancelTimeout() {
        if (this.expr == null) {
            return;
        }
        try {
            this.expr.cancel();
        }
        catch (IllegalStateException ex) {
            this.logger.log(8, "Timer shutting down ", (Throwable)ex);
        }
        this.expr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkExpiration() {
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            if (this.state < 2) {
                this.cancelTimeout();
                this.destroy();
            } else if (this.state > 5) {
                this.cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.tctrl.runnableDestroying(this.id);
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            if (this.state >= 6) {
                return;
            }
            this.setState(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            this.setState(1);
        }
        this.tctrl.releaseRunnable(this);
    }

    protected synchronized void assigned() {
        this.setState(3);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilAssigned() {
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            while (this.state < 3) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilDestroyed(long timeout) {
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            if (this.isCritical()) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean isDestroyed() {
        return this.state == 7;
    }

    protected boolean isBusy() {
        return this.state >= 2 && this.state <= 5;
    }

    protected boolean isCritical() {
        return this.state == 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCritical(boolean critical) {
        this.setState(critical ? 5 : 3);
        if (!critical) {
            BasicRunnable basicRunnable = this;
            synchronized (basicRunnable) {
                this.notifyAll();
            }
        }
    }

    protected abstract void process() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            if (this.state < 1) {
                this.setState(1);
            }
        }
        while (this.state < 6) {
            if (this.suspended) {
                if (DEBUG) {
                    this.logger.log(4, "BasicRunnable: suspending Thread [ {0} ]", (Object)String.valueOf(this.id));
                }
                basicRunnable = this;
                synchronized (basicRunnable) {
                    if (this.suspended && this.tctrl.isSuspended()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.behavior >= 2 || this.state >= 6) break;
            if (this.state < 3) {
                basicRunnable = this;
                synchronized (basicRunnable) {
                    if (this.state < 3) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            try {
                this.process();
            }
            catch (Exception ex) {
                if (this.state < 6) {
                    this.tctrl.handleException(ex);
                    break;
                }
                this.logger.log(4, "Exiting", (Throwable)ex);
                break;
            }
        }
        if (this.state < 6) {
            this.destroy();
        }
        basicRunnable = this;
        synchronized (basicRunnable) {
            this.state = 7;
            this.tctrl.runnableExit(this.id);
            this.notifyAll();
        }
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicRunnable)) {
            return false;
        }
        return ((BasicRunnable)o).id == this.id;
    }

    static class ThreadExpiration
    extends TimerTask {
        BasicRunnable hr = null;

        ThreadExpiration(BasicRunnable hr) {
            this.hr = hr;
        }

        @Override
        public void run() {
            this.hr.checkExpiration();
        }
    }
}

