/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.loader.ResourceLocator;
import com.sun.enterprise.util.io.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import org.glassfish.appclient.common.ClassPathUtils;
import org.glassfish.common.util.GlassfishUrlClassLoader;

public class ACCClassLoader
extends GlassfishUrlClassLoader {
    private static final String AGENT_LOADER_CLASS_NAME = "org.glassfish.appclient.client.acc.agent.ACCAgentClassLoader";
    private static ACCClassLoader instance;
    private ACCClassLoader shadow;
    private boolean shouldTransform;
    private final List<ClassFileTransformer> transformers = Collections.synchronizedList(new ArrayList());

    public static synchronized ACCClassLoader newInstance(ClassLoader parent, boolean shouldTransform) {
        if (instance != null) {
            throw new IllegalStateException("already set");
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        boolean currentCLWasAgentCL = currentClassLoader.getClass().getName().equals(AGENT_LOADER_CLASS_NAME);
        ClassLoader parentForACCCL = currentCLWasAgentCL ? currentClassLoader.getParent() : currentClassLoader;
        instance = new ACCClassLoader(ClassPathUtils.getJavaClassPathForAppClient(), parentForACCCL, shouldTransform);
        if (currentCLWasAgentCL) {
            try {
                ACCClassLoader.adjustACCAgentClassLoaderParent(instance);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return instance;
    }

    public static ACCClassLoader instance() {
        return instance;
    }

    private static void adjustACCAgentClassLoaderParent(ACCClassLoader instance) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader.getClass().getName().equals(AGENT_LOADER_CLASS_NAME) && systemClassLoader instanceof Consumer) {
            Consumer consumerOfClassLoader = (Consumer)((Object)systemClassLoader);
            consumerOfClassLoader.accept(instance);
            System.setProperty("org.glassfish.appclient.acc.agentLoaderDone", "true");
        }
    }

    public ACCClassLoader(ClassLoader parent, boolean shouldTransform) {
        super(new URL[0], parent);
        this.shouldTransform = shouldTransform;
    }

    public ACCClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    private ACCClassLoader(URL[] urls, ClassLoader parent, boolean shouldTransform) {
        this(urls, parent);
        this.shouldTransform = shouldTransform;
    }

    public synchronized void appendURL(URL url) {
        this.addURL(url);
        if (this.shadow != null) {
            this.shadow.addURL(url);
        }
    }

    public void addTransformer(ClassFileTransformer xf) {
        this.transformers.add(xf);
    }

    public void setShouldTransform(boolean shouldTransform) {
        this.shouldTransform = shouldTransform;
    }

    synchronized ACCClassLoader shadow() {
        if (this.shadow == null) {
            this.shadow = new ACCClassLoader(this.getURLs(), this.getParent());
        }
        return this.shadow;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!this.shouldTransform) {
            return this.findClassUnshadowed(name);
        }
        return this.copyClass(this.shadow().findClassUnshadowed(name));
    }

    private Class<?> copyClass(Class<?> sourceClass) throws ClassNotFoundException {
        String name = sourceClass.getName();
        ProtectionDomain pd = sourceClass.getProtectionDomain();
        byte[] bytecode = this.readByteCode(name);
        for (ClassFileTransformer xf : this.transformers) {
            try {
                bytecode = xf.transform((ClassLoader)((Object)this), name, null, pd, bytecode);
            }
            catch (IllegalClassFormatException ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
        return this.defineClass(name, bytecode, 0, bytecode.length, pd);
    }

    private Class<?> findClassUnshadowed(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    private byte[] readByteCode(String className) throws ClassNotFoundException {
        byte[] byArray;
        block9: {
            String resourceName = className.replace('.', '/') + ".class";
            InputStream is = this.getResourceAsStream(resourceName);
            try {
                if (is == null) {
                    throw new ClassNotFoundException(className);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileUtils.copy((InputStream)is, (OutputStream)baos);
                byArray = baos.toByteArray();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(className, e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return new ResourceLocator((URLClassLoader)((Object)this), this.getParentClassLoader(), true).getResources(name);
    }

    private ClassLoader getParentClassLoader() {
        ClassLoader parent = this.getParent();
        if (parent == null) {
            return ACCClassLoader.getSystemClassLoader();
        }
        return parent;
    }
}

