/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.internal;

import jakarta.enterprise.concurrent.ManagedExecutorService;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class ManagedCompletableFuture<T>
extends CompletableFuture<T> {
    private final ManagedExecutorService executor;

    public ManagedCompletableFuture(ManagedExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public Executor defaultExecutor() {
        return this.executor;
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        return new ManagedCompletableFuture<T>(this.executor);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return super.thenApply(this.executor.getContextService().contextualFunction(fn));
    }

    public static <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier, ManagedExecutorService executor) {
        ManagedCompletableFuture managedFuture = new ManagedCompletableFuture(executor);
        executor.execute(() -> {
            try {
                managedFuture.complete(supplier.get());
            }
            catch (Exception e) {
                managedFuture.completeExceptionally(e);
            }
        });
        return managedFuture;
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return this.thenApplyAsync((Function)fn, (Executor)this.executor);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return super.thenApplyAsync(this.executor.getContextService().contextualFunction(fn), executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.thenCombineAsync((CompletionStage)other, this.executor.getContextService().contextualFunction(fn), (Executor)this.executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return super.thenCombineAsync((CompletionStage)other, this.executor.getContextService().contextualFunction(fn), executor);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return super.handleAsync(this.executor.getContextService().contextualFunction(fn));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return super.thenCombine((CompletionStage)other, this.executor.getContextService().contextualFunction(fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.applyToEitherAsync((CompletionStage)other, (Function)fn, (Executor)this.executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return super.applyToEitherAsync((CompletionStage)other, this.executor.getContextService().contextualFunction(fn), executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return super.thenAcceptBoth((CompletionStage)other, this.executor.getContextService().contextualConsumer(action));
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return super.exceptionally(this.executor.getContextService().contextualFunction(fn));
    }

    public static <U> CompletableFuture<U> completedFuture(U value, ManagedExecutorService executor) {
        ManagedCompletableFuture<U> future = new ManagedCompletableFuture<U>(executor);
        future.complete(value);
        return future;
    }

    public static <U> CompletionStage<U> completedStage(U value, ManagedExecutorService executor) {
        ManagedCompletableFuture<U> future = new ManagedCompletableFuture<U>(executor);
        future.complete(value);
        return future;
    }

    public static <U> CompletableFuture<U> failedFuture(Throwable ex, ManagedExecutorService executor) {
        return executor.failedFuture(ex);
    }

    public static <U> CompletionStage<U> failedStage(Throwable ex, ManagedExecutorService executor) {
        return executor.failedStage(ex);
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, ManagedExecutorService executor) {
        return CompletableFuture.runAsync(runnable, (Executor)executor);
    }
}

