/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.spi.TransactionOperationsManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={UserTransactionImpl.class, UserTransaction.class})
@PerLookup
public class UserTransactionImpl
implements UserTransaction,
Serializable {
    private static final long serialVersionUID = -9058595590726479777L;
    static Logger _logger = LogDomains.getLogger(UserTransactionImpl.class, (String)"jakarta.enterprise.resource.jta");
    private static StringManager sm = StringManager.getManager(UserTransactionImpl.class);
    @Inject
    private transient JavaEETransactionManager transactionManager;
    @Inject
    private transient InvocationManager invocationManager;
    private transient boolean initialized;
    private transient UserTransaction userTransaction;
    private boolean checkEjbAccess;

    public UserTransactionImpl() {
        this(true);
    }

    public UserTransactionImpl(boolean doEjbAccessChecks) {
        this.init();
        this.checkEjbAccess = doEjbAccessChecks;
    }

    private void init() {
        this.initialized = true;
    }

    private void checkUserTransactionMethodAccess(ComponentInvocation inv) throws IllegalStateException, SystemException {
        TransactionOperationsManager transactionOperationsManager = (TransactionOperationsManager)inv.getTransactionOperationsManager();
        if (transactionOperationsManager != null && this.checkEjbAccess && !transactionOperationsManager.userTransactionMethodsAllowed()) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.operation_not_allowed"));
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTransaction != null) {
            this.userTransaction.begin();
            return;
        }
        ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
        if (componentInvocation != null) {
            this.checkUserTransactionMethodAccess(componentInvocation);
        }
        this.transactionManager.begin();
        try {
            if (componentInvocation != null) {
                TransactionOperationsManager toMgr = (TransactionOperationsManager)componentInvocation.getTransactionOperationsManager();
                if (toMgr != null) {
                    toMgr.doAfterUtxBegin();
                }
                componentInvocation.setTransaction((Object)this.transactionManager.getTransaction());
                this.transactionManager.enlistComponentResources();
            }
        }
        catch (RemoteException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_begin", ex);
            SystemException sysEx = new SystemException(ex.getMessage());
            sysEx.initCause((Throwable)ex);
            throw sysEx;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTransaction != null) {
            this.userTransaction.commit();
            return;
        }
        ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
        if (componentInvocation != null) {
            this.checkUserTransactionMethodAccess(componentInvocation);
        }
        try {
            this.transactionManager.delistComponentResources(false);
            this.transactionManager.commit();
        }
        catch (RemoteException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_commit", ex);
            throw new SystemException();
        }
        finally {
            if (componentInvocation != null) {
                componentInvocation.setTransaction(null);
            }
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTransaction != null) {
            this.userTransaction.rollback();
            return;
        }
        ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
        if (componentInvocation != null) {
            this.checkUserTransactionMethodAccess(componentInvocation);
        }
        try {
            this.transactionManager.delistComponentResources(false);
            this.transactionManager.rollback();
        }
        catch (RemoteException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_rollback", ex);
            throw new SystemException();
        }
        finally {
            if (componentInvocation != null) {
                componentInvocation.setTransaction(null);
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTransaction != null) {
            this.userTransaction.setRollbackOnly();
            return;
        }
        ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
        if (componentInvocation != null) {
            this.checkUserTransactionMethodAccess(componentInvocation);
        }
        this.transactionManager.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTransaction != null) {
            return this.userTransaction.getStatus();
        }
        ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
        if (componentInvocation != null) {
            this.checkUserTransactionMethodAccess(componentInvocation);
        }
        return this.transactionManager.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTransaction != null) {
            this.userTransaction.setTransactionTimeout(seconds);
            return;
        }
        ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
        if (componentInvocation != null) {
            this.checkUserTransactionMethodAccess(componentInvocation);
        }
        this.transactionManager.setTransactionTimeout(seconds);
    }

    public void setForTesting(JavaEETransactionManager tm, InvocationManager im) {
        this.transactionManager = tm;
        this.invocationManager = im;
        ((JavaEETransactionManagerSimplified)this.transactionManager).invMgr = im;
    }

    Object readResolve() throws ObjectStreamException {
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        if (serviceLocator != null) {
            return serviceLocator.getService(UserTransactionImpl.class, new Annotation[0]);
        }
        return this;
    }
}

